/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.json;

import icu.easyj.core.json.IJSONService;
import icu.easyj.core.loader.EnhancedServiceLoader;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class JSONUtils {
    private static final IJSONService JSON_SERVICE = EnhancedServiceLoader.load(IJSONService.class);

    public static <T> T toBean(String text, @NonNull Class<T> targetClazz) {
        if (text == null) {
            return null;
        }
        Assert.notNull(targetClazz, (String)"'targetClazz' must not be null");
        return JSON_SERVICE.toBean(text, targetClazz);
    }

    public static <T> List<T> toList(String text, @NonNull Class<T> targetClazz) {
        if (text == null) {
            return null;
        }
        Assert.notNull(targetClazz, (String)"'targetClazz' must not be null");
        return JSON_SERVICE.toList(text, targetClazz);
    }

    @NonNull
    public static String toJSONString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        return JSON_SERVICE.toJSONString(obj);
    }
}

