/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.json.impls;

import com.fasterxml.jackson.databind.ObjectMapper;
import icu.easyj.core.json.IJSONService;
import icu.easyj.core.json.JSONParseException;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@LoadLevel(name="jackson", order=20)
@DependsOnClass(value={ObjectMapper.class})
class JacksonJSONServiceImpl
implements IJSONService {
    private final ObjectMapper mapper = new ObjectMapper();

    JacksonJSONServiceImpl() {
    }

    @Override
    @NonNull
    public <T> T toBean(@NonNull String text, @NonNull Class<T> targetClazz) throws JSONParseException {
        try {
            return (T)this.mapper.readValue(text, targetClazz);
        }
        catch (Exception e) {
            throw new JSONParseException("JSON\u5b57\u7b26\u4e32\u8f6cBean\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public <T> List<T> toList(@NonNull String text, @NonNull Class<T> targetClazz) throws JSONParseException {
        try {
            return (List)this.mapper.readerForListOf(targetClazz).readValue(text);
        }
        catch (Exception e) {
            throw new JSONParseException("JSON\u5b57\u7b26\u4e32\u8f6cList\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public String toJSONString(@Nullable Object obj) throws JSONParseException {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new JSONParseException("obj\u8f6cJSON\u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }

    @Override
    @NonNull
    public String getName() {
        return "jackson";
    }
}

