/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.loader.condition;

import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.loader.condition.IDependsOnValidator;
import icu.easyj.core.loader.condition.ServiceDependencyException;

public class DependsOnClassValidator
implements IDependsOnValidator {
    @Override
    public void validate(Class<?> serviceClass, ClassLoader classLoader) throws ServiceDependencyException {
        try {
            String[] dependsOnClassNames;
            DependsOnClass dependsOnClass = serviceClass.getAnnotation(DependsOnClass.class);
            if (dependsOnClass == null) {
                return;
            }
            Class<?>[] dependsOnClasses = dependsOnClass.value();
            for (String dependsOnClassName : dependsOnClassNames = dependsOnClass.name()) {
                Class.forName(dependsOnClassName, true, classLoader);
            }
        }
        catch (ArrayStoreException | ClassNotFoundException | TypeNotPresentException e) {
            throw new ServiceDependencyException("the depends on classes is not found", e);
        }
    }
}

