/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.enums.DateFormatType;
import icu.easyj.core.util.DateFormatFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class DateUtils {
    @NonNull
    public static Date getDate(Date time) {
        return new Date(time.getYear(), time.getMonth(), time.getDate());
    }

    @NonNull
    public static Date getTomorrowDate(@NonNull Date time) {
        return DateUtils.getDate(new Date(time.getTime() + 86400000L));
    }

    @NonNull
    public static Date parse(@NonNull String str, @NonNull DateFormatType format) throws ParseException {
        SimpleDateFormat sdf = DateFormatFactory.get(format);
        return sdf.parse(str);
    }

    @NonNull
    public static Date parse(@NonNull String str, @NonNull String format) throws ParseException {
        SimpleDateFormat sdf = DateFormatFactory.get(format);
        return sdf.parse(str);
    }

    @NonNull
    public static Date parseMonth(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM);
    }

    @NonNull
    public static Date parseDate(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD);
    }

    @NonNull
    public static Date parseMinutes(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI);
    }

    @NonNull
    public static Date parseSeconds(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS);
    }

    @NonNull
    public static Date parseMillisecond(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS);
    }

    @NonNull
    public static Date parseMonth2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM2);
    }

    @NonNull
    public static Date parseDate2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD2);
    }

    public static Date parseMinutes2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI2);
    }

    @NonNull
    public static Date parseSeconds2(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS2);
    }

    @NonNull
    public static Date parseMillisecond2(String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS2);
    }

    @NonNull
    public static Date parseMonth3(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM3);
    }

    @NonNull
    public static Date parseDate3(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD3);
    }

    @NonNull
    public static Date parseMonthUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MM_UNSIGNED);
    }

    @NonNull
    public static Date parseDateUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.DD_UNSIGNED);
    }

    @NonNull
    public static Date parseMinutesUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.MI_UNSIGNED);
    }

    @NonNull
    public static Date parseSecondsUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SS_UNSIGNED);
    }

    @NonNull
    public static Date parseMillisecondUnsigned(@NonNull String str) throws ParseException {
        return DateUtils.parse(str, DateFormatType.SSS_UNSIGNED);
    }

    @NonNull
    public static Date parseAll(@NonNull String timeStr) {
        Assert.notNull((Object)timeStr, (String)"'timeStr' must not be null");
        RuntimeException e = null;
        if (timeStr.contains("-")) {
            timeStr = timeStr.replace('-', '/');
            try {
                return new Date(timeStr);
            }
            catch (RuntimeException re) {
                e = re;
            }
        }
        try {
            switch (timeStr.length()) {
                case 7: {
                    if (timeStr.contains("/")) {
                        return DateUtils.parseMonth2(timeStr);
                    }
                    return DateUtils.parseMonth3(timeStr);
                }
                case 10: {
                    if (timeStr.contains("/")) {
                        return DateUtils.parseDate2(timeStr);
                    }
                    return DateUtils.parseDate3(timeStr);
                }
                case 16: {
                    return DateUtils.parseSeconds2(timeStr);
                }
                case 19: {
                    return DateUtils.parseMinutes2(timeStr);
                }
                case 23: {
                    return DateUtils.parseMillisecond2(timeStr);
                }
                case 6: {
                    return DateUtils.parseMonthUnsigned(timeStr);
                }
                case 8: {
                    return DateUtils.parseDateUnsigned(timeStr);
                }
                case 12: {
                    return DateUtils.parseMinutesUnsigned(timeStr);
                }
                case 14: {
                    return DateUtils.parseSecondsUnsigned(timeStr);
                }
                case 17: {
                    return DateUtils.parseMillisecondUnsigned(timeStr);
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (e != null) {
            throw e;
        }
        return new Date(timeStr);
    }

    @NonNull
    public static String format(@NonNull String dateFormat, @NonNull Date date) {
        Assert.notNull((Object)dateFormat, (String)"'dateFormat' must not be null");
        Assert.notNull((Object)date, (String)"'date' must not be null");
        return DateFormatFactory.get(dateFormat).format(date);
    }

    @NonNull
    public static String format(@NonNull DateFormatType dateFormat, @NonNull Date date) {
        Assert.notNull((Object)((Object)dateFormat), (String)"'dateFormat' must not be null");
        Assert.notNull((Object)date, (String)"'date' must not be null");
        return DateFormatFactory.get(dateFormat).format(date);
    }

    public static String toMonth(Date date) {
        return DateUtils.format(DateFormatType.MM, date);
    }

    public static String toDate(Date date) {
        return DateUtils.format(DateFormatType.DD, date);
    }

    public static String toMinute(Date date) {
        return DateUtils.format(DateFormatType.MI, date);
    }

    public static String toSeconds(Date date) {
        return DateUtils.format(DateFormatType.SS, date);
    }

    public static String toMilliseconds(Date date) {
        return DateUtils.format(DateFormatType.SSS, date);
    }

    public static String toMonth2(Date date) {
        return DateUtils.format(DateFormatType.MM2, date);
    }

    public static String toDate2(Date date) {
        return DateUtils.format(DateFormatType.DD2, date);
    }

    public static String toMinute2(Date date) {
        return DateUtils.format(DateFormatType.MI2, date);
    }

    public static String toSeconds2(Date date) {
        return DateUtils.format(DateFormatType.SS2, date);
    }

    public static String toMilliseconds2(Date date) {
        return DateUtils.format(DateFormatType.SSS2, date);
    }

    public static String toMonth3(Date date) {
        return DateUtils.format(DateFormatType.MM3, date);
    }

    public static String toDate3(Date date) {
        return DateUtils.format(DateFormatType.DD3, date);
    }

    public static String toMonthUnsigned(Date date) {
        return DateUtils.format(DateFormatType.MM_UNSIGNED, date);
    }

    public static String toDateUnsigned(Date date) {
        return DateUtils.format(DateFormatType.DD_UNSIGNED, date);
    }

    public static String toMinuteUnsigned(Date date) {
        return DateUtils.format(DateFormatType.MI_UNSIGNED, date);
    }

    public static String toSecondsUnsigned(Date date) {
        return DateUtils.format(DateFormatType.SS_UNSIGNED, date);
    }

    public static String toMillisecondsUnsigned(Date date) {
        return DateUtils.format(DateFormatType.SSS_UNSIGNED, date);
    }

    @NonNull
    public static String toString(@Nullable Date date) {
        if (date == null) {
            return "null";
        }
        long time = date.getTime();
        DateFormatType dateFormat = date.getHours() == 0 && date.getMinutes() == 0 && date.getSeconds() == 0 && time % 1000L == 0L ? DateFormatType.DD : (time % 60000L == 0L ? DateFormatType.MI : (time % 1000L == 0L ? DateFormatType.SS : DateFormatType.SSS));
        return DateUtils.format(dateFormat, date);
    }
}

