/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.StringUtils;
import java.util.Random;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class ShortCodeUtils {
    private static final char[] DEFAULT_CHAR_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char DEFAULT_SPLIT_CHAR = '0';
    private static final int DEFAULT_MIN_LENGTH = 5;
    public static final char[] URLSAFE_CHAR_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '-', '*', '`', '~', '!', '+', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char URLSAFE_SPLIT_CHAR = '_';

    public static String toCode(long id, @NonNull char[] charTable, char splitChar, int minLength) {
        String str;
        Assert.isTrue((id >= 0L ? 1 : 0) != 0, (String)"ID\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        Assert.notNull((Object)charTable, (String)"'charTable' must not be null");
        int charTableLength = charTable.length;
        if (id > 0L) {
            double power = Math.log(id) / Math.log(charTableLength);
            int charPos = (int)power + 2;
            char[] buf = new char[charPos];
            while (id > 0L) {
                int index = (int)(id % (long)charTableLength);
                buf[--charPos] = charTable[index];
                id /= (long)charTableLength;
            }
            str = charPos == 0 ? new String(buf) : new String(buf, charPos, buf.length - charPos);
        } else {
            str = "";
        }
        if (str.length() < minLength) {
            StringBuilder sb = new StringBuilder();
            sb.append(splitChar);
            Random rnd = new Random();
            for (int i = 1; i < minLength - str.length(); ++i) {
                sb.append(charTable[rnd.nextInt(charTableLength)]);
            }
            str = str + sb.toString();
        }
        return str;
    }

    public static String toCode(long id, @NonNull char[] charTable, char splitChar) {
        return ShortCodeUtils.toCode(id, charTable, splitChar, 5);
    }

    public static String toCode(long id, int minLength) {
        return ShortCodeUtils.toCode(id, DEFAULT_CHAR_TABLE, '0', minLength);
    }

    public static String toCode(long id) {
        return ShortCodeUtils.toCode(id, DEFAULT_CHAR_TABLE, '0', 5);
    }

    public static long toId(String code, @NonNull char[] charsTable, char splitChar) {
        if (StringUtils.isEmpty(code)) {
            return 0L;
        }
        int tableLength = charsTable.length;
        char[] chars = StringUtils.toCharArray(code);
        long res = 0L;
        for (int i = 0; i < chars.length; ++i) {
            int index = 0;
            for (int j = 0; j < tableLength; ++j) {
                if (chars[i] != charsTable[j]) continue;
                index = j;
                break;
            }
            if (chars[i] == splitChar) break;
            res = i > 0 ? res * (long)tableLength + (long)index : (long)index;
        }
        return res;
    }

    public static long toId(String code) {
        return ShortCodeUtils.toId(code, DEFAULT_CHAR_TABLE, '0');
    }
}

