/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.exception.WrapperException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class ThrowableUtils {
    public static final String WRAPPER_EXCEPTION_SUFFIX = "WrapperException";

    @Nullable
    public static <T extends Throwable> T findCause(@NonNull Throwable t, @NonNull Class<T> causeClass) {
        Assert.notNull((Object)t, (String)"'t' must not be null");
        Assert.notNull(causeClass, (String)"'causeClass' must not be null");
        while (t != null) {
            if (causeClass.isAssignableFrom(t.getClass())) {
                return (T)t;
            }
            t = t.getCause();
        }
        return null;
    }

    public static boolean containsCause(@NonNull Throwable t, @NonNull Class<? extends Throwable> causeClass) {
        return ThrowableUtils.findCause(t, causeClass) != null;
    }

    public static Throwable unwrap(@Nullable Throwable t) {
        if (t == null) {
            return null;
        }
        if (t instanceof WrapperException) {
            return t.getCause();
        }
        if (t.getClass().getName().endsWith(WRAPPER_EXCEPTION_SUFFIX) && t.getCause() != null) {
            return t.getCause();
        }
        return t;
    }

    public static Throwable unwrap(@Nullable WrapperException t) {
        if (t == null) {
            return null;
        }
        return t.getCause();
    }
}

