/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import cn.hutool.core.lang.Assert;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.VersionInfo;
import icu.easyj.core.util.version.VersionUtils;
import java.net.URL;
import java.util.jar.Attributes;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JarInfo {
    private final URL url;
    private final String name;
    private final VersionInfo versionInfo;
    private final Attributes manifestAttributes;

    public JarInfo(@NonNull URL url, @NonNull String name, @NonNull Attributes manifestAttributes, @Nullable String version) {
        Assert.notNull((Object)url, (String)"'url' must not be null", (Object[])new Object[0]);
        Assert.isTrue((boolean)StringUtils.isNotBlank(name), (String)"'name' must not be null", (Object[])new Object[0]);
        this.url = url;
        this.name = name.toLowerCase();
        this.versionInfo = VersionUtils.parse(version);
        this.manifestAttributes = manifestAttributes;
    }

    public int compareToVersion(String otherVersion) {
        return this.versionInfo.compareTo(otherVersion);
    }

    @NonNull
    public URL getUrl() {
        return this.url;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @NonNull
    public String getVersion() {
        return this.versionInfo.getVersion();
    }

    public long getVersionLong() {
        return this.versionInfo.getVersionLong();
    }

    @NonNull
    public Attributes getAttributes() {
        return this.manifestAttributes;
    }

    @Nullable
    public String getAttribute(Attributes.Name name) {
        return this.manifestAttributes.getValue(name);
    }

    @Nullable
    public String getAttribute(String name) {
        return this.manifestAttributes.getValue(name);
    }
}

