/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.sequence.impl;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.util.MapUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.lang.NonNull;

@LoadLevel(name="atomicLongSequenceService", order=999)
public class AtomicLongSequenceServiceImpl
implements ISequenceService {
    private final Map<String, AtomicLong> atomicLongMap = new ConcurrentHashMap<String, AtomicLong>();

    @Override
    public long currVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).get();
    }

    @Override
    public long nextVal(@NonNull String seqName) {
        return this.getAtomicLong(seqName).incrementAndGet();
    }

    @Override
    public long setVal(@NonNull String seqName, long newVal) {
        return this.getAtomicLong(seqName).getAndSet(newVal);
    }

    public AtomicLong getAtomicLong(String seqName) {
        return MapUtils.computeIfAbsent(this.atomicLongMap, seqName, k -> new AtomicLong(0L));
    }
}

