/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.StringUtils;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;

public abstract class ArrayUtils {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultValue) {
        if (ArrayUtils.isEmpty(array)) {
            return defaultValue;
        }
        return array;
    }

    public static <T> T[] defaultIfEmpty(T[] array, Supplier<T[]> defaultValueSupplier) {
        if (ArrayUtils.isEmpty(array)) {
            return defaultValueSupplier.get();
        }
        return array;
    }

    @NonNull
    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        return CycleDependencyHandler.wrap(objectArray, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[");
            for (Object obj : objectArray) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (obj == objectArray) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(obj));
            }
            sb.append("]");
            return sb.toString();
        });
    }
}

