/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.version.VersionInfo;
import icu.easyj.core.util.version.VersionUtils;
import java.util.jar.Attributes;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JarInfo {
    private final String filePath;
    private final String name;
    private final VersionInfo versionInfo;
    private final Attributes manifestAttributes;

    public JarInfo(@NonNull String filePath, @NonNull String name, @NonNull Attributes manifestAttributes, @Nullable String version) {
        Assert.notNull((Object)filePath, (String)"'filePath' must not be null");
        Assert.isTrue((boolean)StringUtils.isNotBlank(name), (String)"'name' must not be null");
        this.filePath = filePath;
        this.name = name.toLowerCase();
        this.versionInfo = VersionUtils.parse(version);
        this.manifestAttributes = manifestAttributes;
    }

    public int compareToVersion(String otherVersion) {
        return this.versionInfo.compareTo(otherVersion);
    }

    @NonNull
    public String getFilePath() {
        return this.filePath;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @NonNull
    public String getVersion() {
        return this.versionInfo.getVersion();
    }

    public long getVersionLong() {
        return this.versionInfo.getVersionLong();
    }

    @NonNull
    public Attributes getAttributes() {
        return this.manifestAttributes;
    }

    @Nullable
    public String getAttribute(Attributes.Name name) {
        return this.manifestAttributes.getValue(name);
    }

    @Nullable
    public String getAttribute(String name) {
        return this.manifestAttributes.getValue(name);
    }
}

