/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.shortcode.impls;

import cn.hutool.core.util.ArrayUtil;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.shortcode.impls.DefaultShortCodeServiceImpl;
import java.util.Random;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@LoadLevel(name="min-length", order=100)
public class MinLengthShortCodeServiceImpl
extends DefaultShortCodeServiceImpl {
    public static final char[] DEFAULT_CHAR_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char DEFAULT_SEPARATOR = '0';
    public static final int DEFAULT_MIN_LENGTH = 5;
    private final char separator;
    private final int minLength;

    public MinLengthShortCodeServiceImpl(char[] charTable, char separator, int minLength, boolean needCheckSeparator) {
        super(charTable);
        if (needCheckSeparator && ArrayUtil.contains((char[])charTable, (char)separator)) {
            throw new IllegalArgumentException("\u5b57\u7b26\u96c6\u4e2d\u4e0d\u80fd\u5305\u542b\u5206\u9694\u5b57\u7b26\uff0c\u5426\u5219\u751f\u6210\u7684\u77ed\u5b57\u7b26\u4e32\u5c06\u65e0\u6cd5\u53cd\u5411\u89e3\u6790");
        }
        this.separator = separator;
        this.minLength = minLength;
    }

    public MinLengthShortCodeServiceImpl(char[] charTable, char separator, int minLength) {
        this(charTable, separator, minLength, true);
    }

    public MinLengthShortCodeServiceImpl(char[] charTable, char separator) {
        this(charTable, separator, 5, true);
    }

    public MinLengthShortCodeServiceImpl() {
        this(DEFAULT_CHAR_TABLE, '0', 5, true);
    }

    @Override
    @NonNull
    public String toCode(@NonNull Long id) {
        Assert.isTrue((id != null && id >= 0L ? 1 : 0) != 0, (String)"ID\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
        String shortCode = super.toCode(id);
        if (shortCode.length() < this.minLength) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.separator);
            Random rnd = new Random();
            for (int i = 1; i < this.minLength - shortCode.length(); ++i) {
                sb.append(this.charTable[rnd.nextInt(this.charTable.length)]);
            }
            shortCode = shortCode + sb.toString();
        }
        return shortCode;
    }

    @Override
    public long toId(@NonNull String shortCode) {
        Assert.notNull((Object)shortCode, (String)"'shortCode' must not be null");
        if (shortCode.isEmpty()) {
            return 0L;
        }
        char[] chars = StringUtils.toCharArray(shortCode);
        long id = 0L;
        for (int i = 0; i < chars.length; ++i) {
            int index = 0;
            for (int j = 0; j < this.charTable.length; ++j) {
                if (chars[i] != this.charTable[j]) continue;
                index = j;
                break;
            }
            if (chars[i] == this.separator) break;
            id = i > 0 ? id * (long)this.charTable.length + (long)index : (long)index;
        }
        return id;
    }
}

