/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.jar.JarInfo;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class JarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarUtils.class);
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private static final Map<ClassLoader, List<JarInfo>> CL_JAR_LIST_CACHE = new ConcurrentHashMap<ClassLoader, List<JarInfo>>();
    private static final Map<ClassLoader, Map<String, JarInfo>> CL_JAR_MAP_CACHE = new ConcurrentHashMap<ClassLoader, Map<String, JarInfo>>();

    @NonNull
    public static List<JarInfo> getJarList(@NonNull ClassLoader classLoader) {
        return MapUtils.computeIfAbsent(CL_JAR_LIST_CACHE, classLoader, cl -> Collections.unmodifiableList(JarUtils.loadJarList(cl)));
    }

    @NonNull
    public static List<JarInfo> getJarList() {
        return JarUtils.getJarList(Thread.currentThread().getContextClassLoader());
    }

    @NonNull
    public static Map<String, JarInfo> getJarMap(@NonNull ClassLoader classLoader) {
        return MapUtils.computeIfAbsent(CL_JAR_MAP_CACHE, classLoader, cl -> {
            List<JarInfo> jarList = JarUtils.getJarList(classLoader);
            HashMap<String, JarInfo> jarMap = new HashMap<String, JarInfo>(jarList.size());
            for (JarInfo jar : jarList) {
                JarInfo previousJar = jarMap.put(jar.getName(), jar);
                if (previousJar == null) continue;
                LOGGER.warn("\u5b58\u5728\u91cd\u540d\u7684JAR\uff0c'{}:{}' \u8986\u76d6\u4e86 '{}:{}'", new Object[]{jar.getName(), jar.getVersion(), previousJar.getName(), previousJar.getVersion()});
            }
            return Collections.unmodifiableMap(jarMap);
        });
    }

    @NonNull
    public static Map<String, JarInfo> getJarMap() {
        return JarUtils.getJarMap(Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    public static JarInfo getJar(String name, @NonNull ClassLoader classLoader) {
        if (name == null) {
            return null;
        }
        Map<String, JarInfo> jarMap = JarUtils.getJarMap(classLoader);
        return jarMap.get(name.toLowerCase());
    }

    @Nullable
    public static JarInfo getJar(String name) {
        return JarUtils.getJar(name, Thread.currentThread().getContextClassLoader());
    }

    @NonNull
    private static List<JarInfo> loadJarList(@NonNull ClassLoader classLoader) {
        Enumeration<URL> urls;
        ArrayList<JarInfo> result = new ArrayList<JarInfo>();
        try {
            urls = classLoader.getResources("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            return result;
        }
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            String jarFilePath = url.toString();
            try {
                if (!jarFilePath.endsWith(".jar!/META-INF/MANIFEST.MF")) continue;
                Manifest manifest = new Manifest(url.openStream());
                Attributes attributes = manifest.getMainAttributes();
                String version = attributes.getValue(IMPLEMENTATION_VERSION);
                if (StringUtils.isBlank(version)) {
                    version = attributes.getValue(BUNDLE_VERSION);
                }
                jarFilePath = jarFilePath.substring(0, jarFilePath.lastIndexOf(".jar!/META-INF/MANIFEST.MF"));
                String jarFileName = jarFilePath.substring(jarFilePath.lastIndexOf("/") + 1);
                String name = jarFileName.replaceAll("-\\d.*$", "");
                if (StringUtils.isBlank(version) && name.length() != jarFileName.length() && (version = jarFileName.substring(name.length())).startsWith("-")) {
                    version = version.substring(1);
                }
                result.add(new JarInfo(jarFilePath + ".jar", name, attributes, version));
            }
            catch (IOException | RuntimeException e) {
                LOGGER.warn("\u52a0\u8f7djar\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)jarFilePath, (Object)e);
            }
        }
        result.sort(Comparator.comparing(JarInfo::getName));
        return result;
    }
}

