/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar.impls;

import cn.hutool.core.io.IORuntimeException;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.jar.IJarGroupLoader;
import icu.easyj.core.util.jar.JarContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

@LoadLevel(name="maven", order=0)
public class MavenJarGroupLoaderImpl
implements IJarGroupLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenJarGroupLoaderImpl.class);

    @Override
    public String load(JarContext jarContext) {
        Resource resource = jarContext.getResource("/META-INF/maven/*/" + jarContext.getName() + "/pom.xml");
        if (resource != null) {
            return this.parseGroup(resource);
        }
        Resource[] resources = jarContext.getResources("/META-INF/maven/*/*/pom.xml");
        if (ArrayUtils.isNotEmpty(resources)) {
            for (Resource res : resources) {
                if (!res.toString().contains("/" + jarContext.getName())) continue;
                return this.parseGroup(res);
            }
            String groupResult = null;
            boolean hasMultipleGroup = false;
            for (Resource res : resources) {
                String group = this.parseGroup(res);
                if (groupResult == null) {
                    groupResult = group;
                    continue;
                }
                if (!groupResult.equals(group)) continue;
                hasMultipleGroup = true;
                break;
            }
            if (hasMultipleGroup) {
                StringBuilder sb = new StringBuilder();
                for (Resource res : resources) {
                    sb.append("\r\n - ").append(res);
                }
                LOGGER.warn("JAR '{}' \u4e2d\u5b58\u5728\u591a\u4e2a\u7ec4\u540d\u4e0d\u7edf\u4e00\u7684 'pom.xml' \u6587\u4ef6\uff0c\u73b0\u76f4\u63a5\u8fd4\u56de\u7b2c\u4e00\u4e2a\u7ec4\u540d\uff0c\u6240\u6709pom.xml\u6587\u4ef6\u8def\u5f84\u5982\u4e0b\uff1a{}", (Object)jarContext.getName(), (Object)sb);
            }
            return groupResult;
        }
        return null;
    }

    String parseGroup(Resource resource) {
        String resourceUrl;
        try {
            resourceUrl = resource.getURL().toString();
        }
        catch (IOException e) {
            throw new IORuntimeException("\u8bfb\u53d6 pom.xml \u6587\u4ef6\u8def\u5f84\u5931\u8d25", (Throwable)e);
        }
        return this.parseGroup(resourceUrl);
    }

    String parseGroup(String resourceUrl) {
        String group = resourceUrl.substring(resourceUrl.indexOf("/META-INF/maven/") + "/META-INF/maven/".length());
        group = group.substring(0, group.indexOf(47));
        return group;
    }
}

