/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.context.impls;

import icu.easyj.core.context.Context;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@LoadLevel(name="fast-thread-local", order=0)
@DependsOnClass(value={FastThreadLocal.class})
public class FastThreadLocalContextImpl
implements Context {
    private static final FastThreadLocal<Map<String, Object>> CONTEXT = new FastThreadLocal<Map<String, Object>>(){

        protected Map<String, Object> initialValue() {
            return new HashMap<String, Object>();
        }
    };

    protected Map<String, Object> map() {
        return (Map)CONTEXT.get();
    }

    @Override
    @Nullable
    public <V> V put(String key, V value) {
        return (V)this.map().put(key, value);
    }

    @Override
    @Nullable
    public <V> V get(String key) {
        return (V)this.map().get(key);
    }

    @Override
    @Nullable
    public <V> V remove(String key) {
        return (V)this.map().remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.map().containsKey(key);
    }

    @Override
    @NonNull
    public Map<String, Object> entries() {
        return this.map();
    }

    @Override
    public void clear() {
        this.map().clear();
    }
}

