/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.json;

import icu.easyj.core.json.IJSONService;
import icu.easyj.core.loader.EnhancedServiceLoader;
import java.lang.reflect.Type;
import java.util.List;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class JSONUtils {
    private static final IJSONService JSON_SERVICE = EnhancedServiceLoader.load(IJSONService.class);

    public static <T> T toBean(String text, @NonNull Class<T> targetClazz) {
        if (text == null) {
            return null;
        }
        Assert.notNull(targetClazz, (String)"'targetClazz' must not be null");
        return JSON_SERVICE.toBean(text, targetClazz);
    }

    public static <T> T toBean(String text, @NonNull Type targetType) {
        if (text == null) {
            return null;
        }
        Assert.notNull((Object)targetType, (String)"'targetType' must not be null");
        return JSON_SERVICE.toBean(text, targetType);
    }

    public static <T> T toBean(String text, @NonNull Class<T> rawType, Type ... actualTypeArguments) {
        if (text == null) {
            return null;
        }
        Assert.notNull(rawType, (String)"'rawType' must not be null");
        Assert.notNull((Object)actualTypeArguments, (String)"'actualTypeArguments' must not be null");
        Assert.isTrue((actualTypeArguments.length > 0 ? 1 : 0) != 0, (String)"'actualTypeArguments' must not be empty");
        return JSON_SERVICE.toBean(text, rawType, actualTypeArguments);
    }

    public static <T> List<T> toList(String text, @NonNull Class<T> targetClazz) {
        if (text == null) {
            return null;
        }
        Assert.notNull(targetClazz, (String)"'targetClazz' must not be null");
        return JSON_SERVICE.toList(text, targetClazz);
    }

    @NonNull
    public static String toJSONString(@Nullable Object obj) {
        if (obj == null) {
            return "null";
        }
        return JSON_SERVICE.toJSONString(obj);
    }
}

