/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.loader.condition;

import icu.easyj.core.loader.condition.DependsOnJarVersion;
import icu.easyj.core.loader.condition.IDependsOnValidator;
import icu.easyj.core.loader.condition.ServiceDependencyException;
import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.jar.JarInfo;
import icu.easyj.core.util.jar.JarUtils;
import icu.easyj.core.util.version.VersionUtils;

public class DependsOnJarVersionValidator
implements IDependsOnValidator {
    @Override
    public void validate(Class<?> serviceClass, ClassLoader classLoader) throws ServiceDependencyException {
        String name;
        DependsOnJarVersion dependsOnJarVersion = serviceClass.getAnnotation(DependsOnJarVersion.class);
        if (dependsOnJarVersion == null) {
            return;
        }
        Object[] names = dependsOnJarVersion.name();
        JarInfo jarInfo = null;
        Object[] objectArray = names;
        int n = objectArray.length;
        for (int i = 0; i < n && (jarInfo = JarUtils.getJar(name = objectArray[i], classLoader)) == null; ++i) {
        }
        if (jarInfo == null) {
            throw new ServiceDependencyException("jar " + ArrayUtils.toString(names) + " not found");
        }
        long minVersion = VersionUtils.toLong(dependsOnJarVersion.minVersion());
        long maxVersion = VersionUtils.toLong(dependsOnJarVersion.maxVersion());
        if (minVersion == 0L && maxVersion == 0L) {
            return;
        }
        if (minVersion > 0L && jarInfo.getVersionLong() < minVersion) {
            throw new ServiceDependencyException("JAR[" + jarInfo.getName() + "] version is less than v" + dependsOnJarVersion.minVersion());
        }
        if (maxVersion > 0L && jarInfo.getVersionLong() > maxVersion) {
            throw new ServiceDependencyException("JAR[" + jarInfo.getName() + "] version is greater than v" + dependsOnJarVersion.maxVersion());
        }
    }
}

