/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.loader.condition;

import cn.hutool.system.JavaInfo;
import cn.hutool.system.SystemUtil;
import icu.easyj.core.loader.condition.DependsOnJavaVersion;
import icu.easyj.core.loader.condition.IDependsOnValidator;
import icu.easyj.core.loader.condition.ServiceDependencyException;

public class DependsOnJavaVersionValidator
implements IDependsOnValidator {
    @Override
    public void validate(Class<?> serviceClass, ClassLoader classLoader) throws ServiceDependencyException {
        DependsOnJavaVersion dependsOnJavaVersion = serviceClass.getAnnotation(DependsOnJavaVersion.class);
        if (dependsOnJavaVersion == null) {
            return;
        }
        int dependsOnMinJavaVersion = (int)(dependsOnJavaVersion.min() * 100.0f);
        int dependsOnMaxJavaVersion = (int)(dependsOnJavaVersion.max() * 100.0f);
        dependsOnMaxJavaVersion = this.handleDependsOnMaxJavaVersion(dependsOnMaxJavaVersion);
        if (dependsOnMinJavaVersion > 0 || dependsOnMaxJavaVersion > 0) {
            JavaInfo javaInfo = SystemUtil.getJavaInfo();
            if (dependsOnMinJavaVersion > 0 && javaInfo.getVersionInt() < dependsOnMinJavaVersion) {
                throw new ServiceDependencyException("java version is less than v" + dependsOnJavaVersion.min());
            }
            if (dependsOnMaxJavaVersion > 0 && javaInfo.getVersionInt() > dependsOnMaxJavaVersion) {
                throw new ServiceDependencyException("java version is greater than v" + dependsOnJavaVersion.max());
            }
        }
    }

    private int handleDependsOnMaxJavaVersion(int dependsOnMaxJavaVersion) {
        if (dependsOnMaxJavaVersion > 0) {
            if (dependsOnMaxJavaVersion < 190) {
                if (dependsOnMaxJavaVersion % 10 == 0) {
                    dependsOnMaxJavaVersion += 9;
                }
            } else if (dependsOnMaxJavaVersion % 100 == 0) {
                dependsOnMaxJavaVersion += 99;
            }
        }
        return dependsOnMaxJavaVersion;
    }
}

