/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.ReflectionUtils;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.LoggerFactory;

public abstract class NetUtils {
    public static final String LOCALHOST = "127.0.0.1";
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;
    private static final Class<?> HTTP_URL_CONNECTION_CLASS;
    private static final Method DISCONNECT_METHOD;
    public static final String PORT_RANGE = "1024,65535";

    public static List<String> getIpList() {
        Object ip;
        ArrayList<String> result = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                NetworkInterface ni = netInterfaces.nextElement();
                Enumeration<InetAddress> addresses = ni.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (((InetAddress)ip).isLoopbackAddress() || ((InetAddress)ip).getHostAddress().indexOf(58) != -1 || LOCALHOST.equals(((InetAddress)ip).getHostAddress())) continue;
                    result.add(((InetAddress)ip).getHostAddress());
                }
            }
        }
        catch (Exception ip2) {
            // empty catch block
        }
        if (result.isEmpty()) {
            ip = NetUtils.getIp();
            result.add((String)ip);
        }
        return result;
    }

    public static String getIp() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostAddress();
        }
        catch (UnknownHostException e) {
            LoggerFactory.getLogger(NetUtils.class).warn("\u83b7\u53d6\u672c\u673aIP\u5931\u8d25", (Throwable)e);
            return LOCALHOST;
        }
    }

    public static int randomPort(int startPort, int endPort) {
        if (endPort > 65535 || endPort < 1024) {
            endPort = 65535;
        }
        if (startPort < 1024) {
            startPort = 1024;
        }
        return RandomUtils.nextInt((int)startPort, (int)endPort);
    }

    public static int randomPort(int startPort) {
        return NetUtils.randomPort(startPort, 65535);
    }

    public static int randomPort() {
        return NetUtils.randomPort(1024, 65535);
    }

    public static void disconnect(URLConnection conn) {
        if (conn == null) {
            return;
        }
        try {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            } else if (DISCONNECT_METHOD != null && HTTP_URL_CONNECTION_CLASS.isAssignableFrom(conn.getClass())) {
                DISCONNECT_METHOD.invoke((Object)conn, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Method disconnectMethod;
        Class<?> httpUrlConnectionClass;
        try {
            httpUrlConnectionClass = ReflectionUtils.getClassByName("sun.net.www.protocol.http.HttpURLConnection");
            try {
                disconnectMethod = httpUrlConnectionClass.getMethod("disconnect", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                disconnectMethod = null;
            }
        }
        catch (ClassNotFoundException e) {
            httpUrlConnectionClass = null;
            disconnectMethod = null;
        }
        HTTP_URL_CONNECTION_CLASS = httpUrlConnectionClass;
        DISCONNECT_METHOD = disconnectMethod;
    }
}

