/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util.jar;

import icu.easyj.core.exception.MultipleFilesFoundException;
import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ObjectUtils;
import icu.easyj.core.util.ResourceUtils;
import icu.easyj.core.util.TimeMeter;
import icu.easyj.core.util.jar.IJarGroupLoader;
import icu.easyj.core.util.jar.JarContext;
import icu.easyj.core.util.jar.JarInfo;
import icu.easyj.core.util.version.VersionInfo;
import icu.easyj.core.util.version.VersionUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class JarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarUtils.class);
    private static final List<IJarGroupLoader> JAR_GROUP_LOADER_LIST = EnhancedServiceLoader.loadAll(IJarGroupLoader.class);
    public static final Attributes.Name IMPLEMENTATION_VERSION = Attributes.Name.IMPLEMENTATION_VERSION;
    public static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    public static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    public static final Attributes.Name AUTOMATIC_MODULE_NAME = new Attributes.Name("Automatic-Module-Name");
    private static final Map<ClassLoader, List<JarInfo>> CL_JAR_LIST_CACHE = new ConcurrentHashMap<ClassLoader, List<JarInfo>>();
    private static final Map<ClassLoader, Map<String, JarInfo>> CL_JAR_MAP_CACHE = new ConcurrentHashMap<ClassLoader, Map<String, JarInfo>>();

    @NonNull
    public static List<JarInfo> getJarList(@NonNull ClassLoader classLoader) {
        return MapUtils.computeIfAbsent(CL_JAR_LIST_CACHE, classLoader, JarUtils::loadJarList);
    }

    @NonNull
    public static List<JarInfo> getJarList() {
        return JarUtils.getJarList(Thread.currentThread().getContextClassLoader());
    }

    public static String convertToDescriptionStr(List<JarInfo> jarList) {
        int maxGroupLength = 0;
        int maxNameLength = 0;
        int maxVersionLength = 0;
        int maxLongVersionLength = 0;
        for (JarInfo jar : jarList) {
            if (maxGroupLength < jar.getGroup().length()) {
                maxGroupLength = jar.getGroup().length();
            }
            if (maxNameLength < jar.getName().length()) {
                maxNameLength = jar.getName().length();
            }
            if (maxVersionLength < jar.getVersion().length()) {
                maxVersionLength = jar.getVersion().length();
            }
            if (maxLongVersionLength >= String.valueOf(jar.getVersionLong()).length()) continue;
            maxLongVersionLength = String.valueOf(jar.getVersionLong()).length();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n----------------------------------------------------------\r\n");
        sb.append("\u5f53\u524d\u9879\u76ee\u6240\u6709\u4f9d\u8d56\uff0c\u603b\u5171 ").append(jarList.size()).append(" \u4e2a\r\n");
        sb.append("----------------------------------------------------------\r\n");
        for (JarInfo jar : jarList) {
            sb.append(StringUtils.rightPad((String)jar.getGroup(), (int)maxGroupLength)).append(" : ").append(StringUtils.rightPad((String)jar.getName(), (int)maxNameLength)).append(" : ").append(StringUtils.rightPad((String)ObjectUtils.defaultIfNull(jar.getVersion(), ""), (int)maxVersionLength)).append(" : ").append(StringUtils.leftPad((String)String.valueOf(jar.getVersionLong()), (int)maxLongVersionLength)).append("   ->   ").append(jar.getFilePath()).append("\r\n");
        }
        sb.append("----------------------------------------------------------\r\n\r\n");
        return sb.toString();
    }

    @NonNull
    public static Map<String, JarInfo> getJarMap(@NonNull ClassLoader classLoader) {
        return MapUtils.computeIfAbsent(CL_JAR_MAP_CACHE, classLoader, cl -> {
            List<JarInfo> jarList = JarUtils.getJarList(classLoader);
            HashMap<String, JarInfo> jarMap = new HashMap<String, JarInfo>(jarList.size());
            for (JarInfo jar : jarList) {
                JarInfo previousJar = jarMap.put(jar.getFullName(), jar);
                if (previousJar == null || previousJar.equals(jar)) continue;
                LOGGER.warn("\u5b58\u5728\u91cd\u540d\u7684JAR\uff0c'{}:{}' \u8986\u76d6\u4e86 '{}:{}'", new Object[]{jar.getFilePath(), jar.getVersion(), previousJar.getFilePath(), previousJar.getVersion()});
            }
            return jarMap;
        });
    }

    @NonNull
    public static Map<String, JarInfo> getJarMap() {
        return JarUtils.getJarMap(Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    public static JarInfo getJar(@NonNull String jarName, @NonNull ClassLoader classLoader) {
        Assert.notNull((Object)jarName, (String)"'jarName' must be not null");
        jarName = jarName.toLowerCase();
        JarInfo jarInfo = null;
        if (StringUtils.contains((CharSequence)jarName, (int)58)) {
            Map<String, JarInfo> jarMap = JarUtils.getJarMap(classLoader);
            jarInfo = jarMap.get(jarName);
            if (jarInfo == null) {
                String unknownGroupFullName = "<unknown>" + (jarName.contains(":") ? jarName.substring(jarName.indexOf(58)) : ":" + jarName);
                jarInfo = jarMap.get(unknownGroupFullName);
            }
        } else {
            ArrayList<JarInfo> result = new ArrayList<JarInfo>();
            List<JarInfo> jarList = JarUtils.getJarList(classLoader);
            for (JarInfo jar : jarList) {
                if (!jar.getName().equals(jarName)) continue;
                result.add(jar);
            }
            if (result.size() > 1) {
                StringBuilder sb = new StringBuilder();
                for (JarInfo jar : result) {
                    sb.append("\r\n - ").append(jar.getFullName());
                }
                throw new MultipleFilesFoundException("\u627e\u5230\u591a\u4e2a\u540d\u4e3a '" + jarName + "' \u7684JAR\u4fe1\u606f\uff0c\u65e0\u6cd5\u786e\u5b9a\u662f\u54ea\u4e00\u4e2a\uff0c\u8bf7\u660e\u786eJAR\u6240\u5c5e\u7ec4\u540d\uff1a" + sb);
            }
            jarInfo = (JarInfo)result.get(0);
        }
        return jarInfo;
    }

    @Nullable
    public static JarInfo getJar(@NonNull String group, @NonNull String name, @NonNull ClassLoader classLoader) {
        Assert.notNull((Object)group, (String)"'group' must be not null");
        Assert.notNull((Object)name, (String)"'name' must be not null");
        return JarUtils.getJar(group + ":" + name, classLoader);
    }

    @Nullable
    public static JarInfo getJar(String jarName) {
        return JarUtils.getJar(jarName, Thread.currentThread().getContextClassLoader());
    }

    @Nullable
    public static JarInfo getJar(@NonNull String group, @NonNull String name) {
        return JarUtils.getJar(group, name, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private static List<JarInfo> loadJarList(@NonNull ClassLoader classLoader) {
        ArrayList<JarInfo> result = new ArrayList<JarInfo>();
        TimeMeter tm = TimeMeter.create();
        try {
            Resource[] resources;
            for (Resource resource : resources = ResourceUtils.getResources("classpath*:/META-INF/MANIFEST.MF")) {
                String jarFilePath = null;
                try {
                    VersionInfo versionInfo;
                    JarContext context;
                    String group;
                    jarFilePath = resource.getURL().toString();
                    if (!jarFilePath.endsWith(".jar!/META-INF/MANIFEST.MF")) continue;
                    Manifest manifest = new Manifest(resource.getInputStream());
                    Attributes attributes = manifest.getMainAttributes();
                    String version = attributes.getValue(IMPLEMENTATION_VERSION);
                    if (StringUtils.isBlank((CharSequence)version)) {
                        version = attributes.getValue(BUNDLE_VERSION);
                    }
                    jarFilePath = jarFilePath.substring(0, jarFilePath.lastIndexOf(".jar!/META-INF/MANIFEST.MF"));
                    String jarFileName = jarFilePath.substring(jarFilePath.lastIndexOf("/") + 1);
                    String name = jarFileName.replaceAll("-\\d.*$", "");
                    jarFilePath = jarFilePath + ".jar";
                    if (StringUtils.isBlank((CharSequence)version) && name.length() != jarFileName.length() && (version = jarFileName.substring(name.length())).startsWith("-")) {
                        version = version.substring(1);
                    }
                    if (StringUtils.isBlank((CharSequence)(group = JarUtils.loadGroup(context = new JarContext(jarFilePath, name, versionInfo = VersionUtils.parse(version), manifest, attributes))))) {
                        group = "<unknown>";
                    }
                    result.add(new JarInfo(jarFilePath, group, name, attributes, context.getVersionInfo()));
                }
                catch (IOException | RuntimeException e) {
                    LOGGER.warn("\u52a0\u8f7dJAR\u4fe1\u606f\u5931\u8d25\uff1a{}", jarFilePath == null ? resource : jarFilePath, (Object)e);
                }
            }
            result.sort((a, b) -> {
                if (a.getGroup().equals(b.getGroup())) {
                    return a.getName().compareTo(b.getName());
                }
                return a.getGroup().compareTo(b.getGroup());
            });
        }
        catch (Throwable throwable) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5171\u52a0\u8f7dJAR\u4fe1\u606f {} \u4e2a\uff0c\u8017\u65f6: {} ms, \u7c7b\u52a0\u8f7d\u5668\u4e3a\uff1a{}", new Object[]{result.size(), tm.spendMilliSeconds(), classLoader});
            }
            throw throwable;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5171\u52a0\u8f7dJAR\u4fe1\u606f {} \u4e2a\uff0c\u8017\u65f6: {} ms, \u7c7b\u52a0\u8f7d\u5668\u4e3a\uff1a{}", new Object[]{result.size(), tm.spendMilliSeconds(), classLoader});
        }
        return result;
    }

    private static String loadGroup(JarContext context) {
        String group = null;
        for (IJarGroupLoader groupLoader : JAR_GROUP_LOADER_LIST) {
            group = groupLoader.load(context);
            if (!StringUtils.isNotBlank((CharSequence)group)) continue;
            return group;
        }
        return group;
    }
}

