/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import icu.easyj.core.util.CycleDependencyHandler;
import icu.easyj.core.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;

public abstract class ArrayUtils {
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    public static final Throwable[] EMPTY_THROWABLE_ARRAY = new Throwable[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> T[] defaultIfEmpty(T[] array, T[] defaultValue) {
        if (ArrayUtils.isEmpty(array)) {
            return defaultValue;
        }
        return array;
    }

    public static <T> T[] defaultIfEmpty(T[] array, Supplier<T[]> defaultValueSupplier) {
        if (ArrayUtils.isEmpty(array)) {
            return defaultValueSupplier.get();
        }
        return array;
    }

    public static Object[] toArray(Object arrayObj) {
        if (arrayObj == null) {
            return null;
        }
        if (!arrayObj.getClass().isArray()) {
            throw new ClassCastException("'arrayObj' is not an array, can't cast to Object[]");
        }
        int length = Array.getLength(arrayObj);
        Object[] array = new Object[length];
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                array[i] = Array.get(arrayObj, i);
            }
        }
        return array;
    }

    @NonNull
    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        return CycleDependencyHandler.wrap(objectArray, o -> {
            StringBuilder sb = new StringBuilder(32);
            sb.append("[");
            for (Object obj : objectArray) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                if (obj == objectArray) {
                    sb.append("(this ").append(obj.getClass().getSimpleName()).append(")");
                    continue;
                }
                sb.append(StringUtils.toString(obj));
            }
            sb.append("]");
            return sb.toString();
        });
    }

    @NonNull
    public static String toString(Object arrayObj) {
        if (arrayObj == null) {
            return "null";
        }
        if (!arrayObj.getClass().isArray()) {
            return StringUtils.toString(arrayObj);
        }
        if (Array.getLength(arrayObj) == 0) {
            return "[]";
        }
        if (arrayObj.getClass().getComponentType().isPrimitive()) {
            return ArrayUtils.toString(ArrayUtils.toArray(arrayObj));
        }
        return ArrayUtils.toString((Object[])arrayObj);
    }
}

