/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import cn.hutool.core.clone.CloneSupport;
import icu.easyj.core.convert.ConvertUtils;
import icu.easyj.core.exception.ConvertException;
import icu.easyj.core.util.CollectionUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class ObjectUtils {
    public static <T> T mergeData(@NonNull T target, @Nullable Map<String, Object> data, CloneMode cloneMode) {
        Field[] fields;
        if (MapUtils.isEmpty(data)) {
            return (T)(cloneMode == CloneMode.ALWAYS_CLONE ? ((CloneSupport)target).clone() : target);
        }
        T result = cloneMode != CloneMode.NOT_CLONE ? ((CloneSupport)target).clone() : target;
        for (Field field : fields = ReflectionUtils.getAllFields(result.getClass())) {
            Object value;
            if (Modifier.isFinal(field.getModifiers()) || (value = data.get(field.getName())) == null) continue;
            if (!value.getClass().equals(field.getType())) {
                try {
                    value = ConvertUtils.convert(value, field.getType());
                }
                catch (ConvertException ignore) {
                    continue;
                }
            }
            try {
                field.set(result, value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }

    public static <T> T mergeData(@NonNull T target, @Nullable Map<String, Object> data) {
        return ObjectUtils.mergeData(target, data, CloneMode.CLONE_ONLY_DATA_NOT_EMPTY);
    }

    @SafeVarargs
    public static <T> boolean in(T obj, T ... array) {
        for (T t : array) {
            if (!Objects.equals(obj, t)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean notIn(T obj, T ... array) {
        return !ObjectUtils.in(obj, array);
    }

    @Nullable
    public static <T> T find(T[] objArr, Predicate<T> objMatcher) {
        for (T obj : objArr) {
            if (!objMatcher.test(obj)) continue;
            return obj;
        }
        return null;
    }

    public static <T> T defaultIfNull(T obj, T defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        return obj;
    }

    public static <T> T defaultIfNull(T obj, Supplier<T> defaultValueSupplier) {
        if (obj == null) {
            return defaultValueSupplier.get();
        }
        return obj;
    }

    public static <T> T defaultIfEmpty(T obj, T defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof CharSequence) {
            return (T)StringUtils.defaultIfEmpty((CharSequence)obj, (CharSequence)defaultValue);
        }
        if (obj instanceof Collection) {
            return (T)CollectionUtils.defaultIfEmpty((Collection)obj, (Collection)defaultValue);
        }
        if (obj instanceof Map) {
            return (T)MapUtils.defaultIfEmpty((Map)obj, (Map)defaultValue);
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return defaultValue;
        }
        return obj;
    }

    public static <T> T defaultIfEmpty(T obj, Supplier<T> defaultValueSupplier) {
        if (obj == null || obj instanceof CharSequence && StringUtils.isEmpty((CharSequence)obj) || obj instanceof Collection && CollectionUtils.isEmpty((Collection)obj) || obj instanceof Map && MapUtils.isEmpty((Map)obj) || obj.getClass().isArray() && Array.getLength(obj) == 0) {
            return defaultValueSupplier.get();
        }
        return obj;
    }

    public static enum CloneMode {
        NOT_CLONE,
        CLONE_ONLY_DATA_NOT_EMPTY,
        ALWAYS_CLONE;

    }
}

