/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class PatternUtils {
    public static final String REGEX_CHINESE_CHAR = "[\u4e00-\u9fa5]";
    public static final String REGEX_CODE_STRING1 = "'((?<=\\\\)'|[^'])*'";
    public static final String REGEX_CODE_STRING2 = "\"((?<=\\\\)\"|[^\"])*\"";
    public static final String REGEX_CODE_STRING = "('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")";
    public static final String REGEX_CODE_NUMBER = "-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)";
    public static final String REGEX_CODE_BOOLEAN = "(true|false)";
    public static final String REGEX_CODE_NULL = "null";
    public static final String REGEX_CODE_VALUE = "(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)";
    public static final Pattern P_CODE_DATA_VALUE = Pattern.compile("(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)");
    public static final String REGEX_CODE_LINE = "^(\\w+)(\\.(\\w+)(\\(((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)(,\\s?(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null))*)?\\)(?=(;|$)))?)?;?$";
    public static final Pattern P_CODE_LINE = Pattern.compile("^(\\w+)(\\.(\\w+)(\\(((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)(,\\s?(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null))*)?\\)(?=(;|$)))?)?;?$");
    public static final String REGEX_CODE_LINE2 = "^(\\w+)\\s*(\\.\\s*(\\w+)\\s*(\\(\\s*((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)\\s*(,\\s*(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)\\s*)*)?\\)(?=(\\s|;|$)))?)?\\s*;?$";
    public static final Pattern P_CODE_LINE2 = Pattern.compile("^(\\w+)\\s*(\\.\\s*(\\w+)\\s*(\\(\\s*((('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)\\s*(,\\s*(('((?<=\\\\)'|[^'])*'|\"((?<=\\\\)\"|[^\"])*\")|-?(\\d+((\\.\\d*[fFdD]?)|[lL])?)|(true|false)|null)\\s*)*)?\\)(?=(\\s|;|$)))?)?\\s*;?$");
    public static final String REGEX_NORMAL_VERSION = "^\\d+(\\.\\d+)*(-SNAPSHOT)?$";
    public static final Pattern P_NORMAL_VERSION = Pattern.compile("^\\d+(\\.\\d+)*(-SNAPSHOT)?$");

    public static boolean validate(@NonNull Pattern pattern, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)pattern, (String)"'pattern' must not be null");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static boolean validate(@NonNull String regex, @Nullable CharSequence str) {
        if (str == null) {
            return false;
        }
        Assert.notNull((Object)regex, (String)"'regex' must not be null");
        Pattern p = Pattern.compile(regex);
        return PatternUtils.validate(p, str);
    }
}

