/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto.asymmetric;

import cn.hutool.core.codec.BCD;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface IAsymmetricCrypto {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (String)charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType, Charset charset) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StrUtil.bytes((CharSequence)data, (Charset)CharsetUtil.CHARSET_UTF_8), keyType);
    }

    default public String encryptHex(String data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptHex(String data, KeyType keyType, Charset charset) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType, charset));
    }

    default public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(String data, KeyType keyType, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, keyType, charset));
    }

    default public byte[] encrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    default public String encryptHex(InputStream data, KeyType keyType) {
        return HexUtil.encodeHexStr((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode((byte[])this.encrypt(data, keyType));
    }

    default public String encryptBcd(String data, KeyType keyType) {
        return this.encryptBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public String encryptBcd(String data, KeyType keyType, Charset charset) {
        return BCD.bcdToStr((byte[])this.encrypt(data, keyType, charset));
    }

    public byte[] decrypt(byte[] var1, KeyType var2);

    default public byte[] decrypt(InputStream data, KeyType keyType) throws IORuntimeException {
        return this.decrypt(IoUtil.readBytes((InputStream)data), keyType);
    }

    default public byte[] decrypt(String data, KeyType keyType) {
        return this.decrypt(SecureUtil.decode((String)data), keyType);
    }

    default public String decryptStr(String data, KeyType keyType, Charset charset) {
        return StrUtil.str((byte[])this.decrypt(data, keyType), (Charset)charset);
    }

    default public String decryptStr(String data, KeyType keyType) {
        return this.decryptStr(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType) {
        return this.decryptFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }

    default public byte[] decryptFromBcd(String data, KeyType keyType, Charset charset) {
        Assert.notNull((Object)data, (String)"Bcd string must be not null!", (Object[])new Object[0]);
        byte[] dataBytes = BCD.ascToBcd((byte[])StrUtil.bytes((CharSequence)data, (Charset)charset));
        return this.decrypt(dataBytes, keyType);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType, Charset charset) {
        return StrUtil.str((byte[])this.decryptFromBcd(data, keyType, charset), (Charset)charset);
    }

    default public String decryptStrFromBcd(String data, KeyType keyType) {
        return this.decryptStrFromBcd(data, keyType, CharsetUtil.CHARSET_UTF_8);
    }
}

