/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto.asymmetric;

import cn.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import cn.hutool.crypto.asymmetric.KeyType;
import icu.easyj.crypto.asymmetric.IAsymmetricCrypto;
import org.springframework.util.Assert;

public class HutoolAsymmetricCryptoAdapter
implements IAsymmetricCrypto {
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final AbstractAsymmetricCrypto<?> asymmetricCrypto;

    public <T extends AbstractAsymmetricCrypto<T>> HutoolAsymmetricCryptoAdapter(String algorithm, T asymmetricCrypto) {
        Assert.notNull(asymmetricCrypto, (String)"asymmetricCrypto must be not null");
        this.algorithm = algorithm;
        this.asymmetricCrypto = asymmetricCrypto;
    }

    public AbstractAsymmetricCrypto<?> getCrypto() {
        return this.asymmetricCrypto;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] encrypt(byte[] data) {
        if (data == null) {
            return null;
        }
        return this.asymmetricCrypto.encrypt(data, KeyType.PublicKey);
    }

    @Override
    public byte[] decrypt(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return this.asymmetricCrypto.decrypt(bytes, KeyType.PrivateKey);
    }
}

