/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto;

import cn.hutool.crypto.KeyUtil;
import cn.hutool.crypto.SecureUtil;
import icu.easyj.crypto.asymmetric.IAsymmetricCrypto;
import icu.easyj.crypto.symmetric.ISymmetricCrypto;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public interface ICryptoGenerator {
    public ISymmetricCrypto getSymmetricCrypto(@NonNull String var1, @NonNull SecretKey var2, @Nullable AlgorithmParameterSpec var3);

    default public ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull byte[] key, byte[] iv) {
        Assert.notNull((Object)algorithm, (String)"algorithmStr must be not null");
        Assert.notNull((Object)key, (String)"key must be not null");
        String algorithmType = algorithm.substring(0, algorithm.indexOf(47));
        SecretKey secretKey = SecureUtil.generateKey((String)algorithmType, (byte[])key);
        IvParameterSpec parameterSpec = ArrayUtils.isNotEmpty((byte[])iv) ? new IvParameterSpec(iv) : null;
        return this.getSymmetricCrypto(algorithm, secretKey, parameterSpec);
    }

    default public ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, @Nullable String iv) {
        return this.getSymmetricCrypto(algorithm, key, iv, StandardCharsets.UTF_8);
    }

    default public ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull String key, String iv, Charset charset) {
        Assert.notNull((Object)algorithm, (String)"algorithmStr must be not null");
        Assert.notNull((Object)key, (String)"key must be not null");
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        byte[] keyBytes = key.getBytes(charset);
        byte[] ivBytes = StringUtils.hasLength((String)iv) ? iv.getBytes(charset) : null;
        return this.getSymmetricCrypto(algorithm, keyBytes, ivBytes);
    }

    public IAsymmetricCrypto getAsymmetricCrypto(@NonNull String var1, @NonNull PublicKey var2, @NonNull PrivateKey var3);

    default public IAsymmetricCrypto getAsymmetricCrypto(String algorithm, byte[] publicKey, byte[] privateKey) {
        return this.getAsymmetricCrypto(algorithm, KeyUtil.generatePublicKey((String)algorithm, (byte[])publicKey), KeyUtil.generatePrivateKey((String)algorithm, (byte[])privateKey));
    }

    default public IAsymmetricCrypto getAsymmetricCrypto(String algorithm, String publicKeyStr, String privateKeyStr) {
        return this.getAsymmetricCrypto(algorithm, SecureUtil.decode((String)publicKeyStr), SecureUtil.decode((String)privateKeyStr));
    }
}

