/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.crypto.impls;

import cn.hutool.crypto.asymmetric.AsymmetricCrypto;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.crypto.ICryptoGenerator;
import icu.easyj.crypto.asymmetric.HutoolAsymmetricCryptoAdapter;
import icu.easyj.crypto.asymmetric.IAsymmetricCrypto;
import icu.easyj.crypto.symmetric.HutoolSymmetricCryptoAdapter;
import icu.easyj.crypto.symmetric.ISymmetricCrypto;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@LoadLevel(name="hutool", order=100)
public class HutoolCryptoGenerator
implements ICryptoGenerator {
    @Override
    public ISymmetricCrypto getSymmetricCrypto(@NonNull String algorithm, @NonNull SecretKey secretKey, @Nullable AlgorithmParameterSpec algorithmParameterSpec) {
        SymmetricCrypto symmetricCrypto = new SymmetricCrypto(algorithm, secretKey, algorithmParameterSpec);
        return new HutoolSymmetricCryptoAdapter(algorithm, symmetricCrypto);
    }

    @Override
    public IAsymmetricCrypto getAsymmetricCrypto(@NonNull String algorithm, @NonNull PublicKey publicKey, @NonNull PrivateKey privateKey) {
        Assert.notNull((Object)algorithm, (String)"'algorithm' must be not null");
        Assert.notNull((Object)publicKey, (String)"'publicKey' must be not null");
        Assert.notNull((Object)privateKey, (String)"'privateKey' must be not null");
        AsymmetricCrypto asymmetricCrypto = new AsymmetricCrypto(algorithm, privateKey, publicKey);
        return new HutoolAsymmetricCryptoAdapter(algorithm, asymmetricCrypto);
    }
}

