/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.util;

import icu.easyj.core.clock.ITickClock;
import icu.easyj.db.util.DbClockFactory;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class DbClockUtils {
    private static DataSource primaryDataSource;
    private static ITickClock primaryClock;

    private static DbClockFactory getFactory() {
        return DbClockFactory.getInstance();
    }

    @NonNull
    private static ITickClock createClock(DataSource dataSource) {
        return DbClockUtils.getFactory().createClock(dataSource);
    }

    @NonNull
    public static ITickClock getClock(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must be not null");
        if (dataSource == primaryDataSource) {
            return primaryClock;
        }
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static ITickClock refreshClock(DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must be not null");
        if (dataSource == primaryDataSource) {
            return DbClockUtils.setPrimaryDataSource(dataSource);
        }
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static Date now(DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).now();
    }

    public static long currentTimeMillis(DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMillis();
    }

    public static long currentTimeMicros(DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMicros();
    }

    public static long currentTimeNanos(DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeNanos();
    }

    private static synchronized void setPrimaryDataSourceClock(DataSource primaryDataSource, ITickClock primaryClock) {
        DbClockUtils.primaryDataSource = primaryDataSource;
        DbClockUtils.primaryClock = primaryClock;
    }

    @Nullable
    public static DataSource getPrimaryDataSource() {
        return primaryDataSource;
    }

    public static ITickClock setPrimaryDataSource(DataSource primaryDataSource) {
        ITickClock primaryClock = DbClockUtils.createClock(primaryDataSource);
        DbClockUtils.setPrimaryDataSourceClock(primaryDataSource, primaryClock);
        return primaryClock;
    }

    @Nullable
    public static ITickClock getClock() {
        return primaryClock;
    }

    @NonNull
    public static synchronized ITickClock refreshClock() {
        if (primaryDataSource == null) {
            throw new RuntimeException("`primaryDataSource`\u672a\u8bbe\u7f6e\uff0c\u8bf7\u5148\u8bbe\u7f6e\uff01");
        }
        return DbClockUtils.setPrimaryDataSource(primaryDataSource);
    }

    public static Date now() {
        return primaryClock.now();
    }

    public static long currentTimeMillis() {
        return primaryClock.currentTimeMillis();
    }

    public static long currentTimeMicros() {
        return primaryClock.currentTimeMicros();
    }

    public static long currentTimeNanos() {
        return primaryClock.currentTimeNanos();
    }
}

