/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.service.impls;

import cn.hutool.core.lang.Assert;
import icu.easyj.core.loader.EnhancedServiceLoader;
import icu.easyj.core.loader.EnhancedServiceNotFoundException;
import icu.easyj.db.dialect.DbDialectAdapter;
import icu.easyj.db.dialect.IDbDialect;
import icu.easyj.db.service.IDbService;
import icu.easyj.db.util.DbUtils;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonDbServiceImpl
extends DbDialectAdapter
implements IDbService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonDbServiceImpl.class);
    protected final DataSource dataSource;

    public CommonDbServiceImpl(DataSource dataSource) {
        super(() -> {
            String dbType = DbUtils.getDbType(dataSource);
            try {
                return (IDbDialect)EnhancedServiceLoader.load(IDbDialect.class, (String)dbType);
            }
            catch (EnhancedServiceNotFoundException e) {
                LOGGER.error("\u672a\u627e\u5230\u6570\u636e\u5e93 '{}' \u7684\u65b9\u8a00\u670d\u52a1\uff0c\u8bf7\u4f7f\u7528 `{}` \u7684\u65b9\u5f0f\u81ea\u884c\u5b9e\u73b0\uff0c\u8bf7\u53c2\u7167MySQL\u65b9\u8a00\u5b9e\u73b0\u7c7b\uff1aMySqlDbDialect", (Object)dbType, (Object)EnhancedServiceLoader.class.getSimpleName());
                throw new EnhancedServiceNotFoundException("\u672a\u627e\u5230\u6570\u636e\u5e93 '" + dbType + "' \u7684\u65b9\u8a00\u670d\u52a1", (Throwable)e);
            }
        });
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null", (Object[])new Object[0]);
        this.dataSource = dataSource;
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }
}

