/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.util;

import icu.easyj.core.clock.ITickClock;
import icu.easyj.db.util.DbClockFactory;
import icu.easyj.db.util.PrimaryDataSourceHolder;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class DbClockUtils {
    private static DbClockFactory getFactory() {
        return DbClockFactory.getInstance();
    }

    @NonNull
    public static ITickClock getClock(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static ITickClock refreshClock(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static Date now(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).now();
    }

    public static long currentTimeMillis(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMillis();
    }

    public static long currentTimeMicros(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMicros();
    }

    public static long currentTimeNanos(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeNanos();
    }

    @NonNull
    public static ITickClock getClock() {
        return DbClockUtils.getClock(PrimaryDataSourceHolder.get());
    }

    @NonNull
    public static ITickClock refreshClock() {
        return DbClockUtils.refreshClock(PrimaryDataSourceHolder.get());
    }

    @NonNull
    public static Date now() {
        return DbClockUtils.now(PrimaryDataSourceHolder.get());
    }

    public static long currentTimeMillis() {
        return DbClockUtils.currentTimeMillis(PrimaryDataSourceHolder.get());
    }

    public static long currentTimeMicros() {
        return DbClockUtils.currentTimeMicros(PrimaryDataSourceHolder.get());
    }

    public static long currentTimeNanos() {
        return DbClockUtils.currentTimeNanos(PrimaryDataSourceHolder.get());
    }
}

