/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.dialect.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.db.dialect.IDbDialect;
import icu.easyj.db.util.SqlUtils;
import org.springframework.lang.NonNull;

@LoadLevel(name="mysql", order=10)
@DependsOnClass(name={"com.mysql.cj.jdbc.Driver"})
class MySqlDbDialect
implements IDbDialect {
    MySqlDbDialect() {
    }

    @Override
    public String getVersionSql() {
        return "SELECT VERSION()";
    }

    @Override
    public String getTimeSql() {
        return "SELECT CURRENT_TIMESTAMP(3)";
    }

    @Override
    public String getSeqCurrValSql(String seqName) {
        return "SELECT func_currval('" + SqlUtils.removeDangerousCharsForSeqName(seqName) + "')";
    }

    @Override
    public String getSeqNextValSql(String seqName) {
        return "SELECT func_nextval('" + SqlUtils.removeDangerousCharsForSeqName(seqName) + "')";
    }

    @Override
    public String getSeqSetValSql(String seqName, long newVal) {
        return "SELECT func_setval('" + SqlUtils.removeDangerousCharsForSeqName(seqName) + "', " + newVal + ")";
    }

    @Override
    @NonNull
    public String getDbType() {
        return "mysql";
    }
}

