/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.sequence.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.db.util.DbUtils;
import icu.easyj.db.util.PrimaryDbUtils;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@LoadLevel(name="db", order=1000)
public class DbSequenceServiceImpl
implements ISequenceService {
    @Nullable
    private final DataSource dataSource;

    public DbSequenceServiceImpl() {
        this(null);
    }

    public DbSequenceServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long nextVal(@NonNull String seqName) {
        if (this.dataSource != null) {
            return DbUtils.seqNextVal(this.dataSource, seqName);
        }
        return PrimaryDbUtils.seqNextVal(seqName);
    }

    public long currVal(@NonNull String seqName) {
        if (this.dataSource != null) {
            return DbUtils.seqCurrVal(this.dataSource, seqName);
        }
        return PrimaryDbUtils.seqCurrVal(seqName);
    }

    public void setVal(@NonNull String seqName, long newVal) {
        if (this.dataSource != null) {
            DbUtils.seqSetVal(this.dataSource, seqName, newVal);
        } else {
            PrimaryDbUtils.seqSetVal(seqName, newVal);
        }
    }
}

