/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.util;

import icu.easyj.core.clock.IAutoRefreshTickClock;
import icu.easyj.db.util.DbClockFactory;
import icu.easyj.db.util.PrimaryDbClockUtils;
import java.util.Date;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public abstract class DbClockUtils
extends PrimaryDbClockUtils {
    private static DbClockFactory getFactory() {
        return DbClockFactory.getInstance();
    }

    @NonNull
    public static IAutoRefreshTickClock getClock(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static IAutoRefreshTickClock refreshClock(@NonNull DataSource dataSource) {
        Assert.notNull((Object)dataSource, (String)"'dataSource' must not be null");
        return DbClockUtils.getFactory().getClock(dataSource);
    }

    @NonNull
    public static Date now(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).now();
    }

    public static long currentTimeMillis(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMillis();
    }

    public static long currentTimeMicros(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeMicros();
    }

    public static long currentTimeNanos(@NonNull DataSource dataSource) {
        return DbClockUtils.getClock(dataSource).currentTimeNanos();
    }
}

