/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.sequence.impls;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.db.util.DbUtils;
import icu.easyj.db.util.PrimaryDbUtils;
import javax.sql.DataSource;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class DataBaseSequenceServiceImpl
implements ISequenceService {
    @Nullable
    private final DataSource dataSource;

    public DataBaseSequenceServiceImpl() {
        this(null);
    }

    public DataBaseSequenceServiceImpl(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public long nextVal(@NonNull String seqName) {
        if (this.dataSource != null) {
            return DbUtils.seqNextVal(this.dataSource, seqName);
        }
        return PrimaryDbUtils.seqNextVal(seqName);
    }

    public long currVal(@NonNull String seqName) {
        if (this.dataSource != null) {
            return DbUtils.seqCurrVal(this.dataSource, seqName);
        }
        return PrimaryDbUtils.seqCurrVal(seqName);
    }

    public long setVal(@NonNull String seqName, long newVal) {
        if (this.dataSource != null) {
            return DbUtils.seqSetVal(this.dataSource, seqName, newVal);
        }
        return PrimaryDbUtils.seqSetVal(seqName, newVal);
    }
}

