/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.db.dialect.impls;

import icu.easyj.core.exception.NotSupportedException;
import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.db.dialect.IDbDialect;
import icu.easyj.db.util.SqlUtils;
import org.springframework.lang.NonNull;

@LoadLevel(name="ms_sql_server", order=30)
@DependsOnClass(name={"com.microsoft.sqlserver.jdbc.SQLServerDriver"})
class MsSqlServerDbDialect
implements IDbDialect {
    MsSqlServerDbDialect() {
    }

    @Override
    public String getVersionSql() {
        return "SELECT SERVERPROPERTY('PRODUCTVERSION')";
    }

    @Override
    public String getTimeSql() {
        return "SELECT GETDATE()";
    }

    @Override
    public String getSeqCurrValSql(String seqName) {
        throw new NotSupportedException("\u6682\u4e0d\u652f\u6301MS SQL Server\u83b7\u53d6\u5f53\u524d\u5e8f\u5217\u503c");
    }

    @Override
    public String getSeqNextValSql(String seqName) {
        return "SELECT NEXT VALUE FOR " + SqlUtils.removeDangerousCharsForSeqName(seqName);
    }

    @Override
    public String getSeqSetValSql(String seqName, long newVal) {
        throw new NotSupportedException("\u6682\u4e0d\u652f\u6301MS SQL Server\u8bbe\u7f6e\u5e8f\u5217\u503c");
    }

    @Override
    @NonNull
    public String getDbType() {
        return "ms_sql_server";
    }
}

