/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.service.impls;

import icu.easyj.core.exception.NotSupportedException;
import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.middleware.dwz.server.core.service.IDwzCorrectErrorDataService;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDwzCorrectErrorDataServiceImpl
implements IDwzCorrectErrorDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDwzCorrectErrorDataServiceImpl.class);
    private final IDwzLogStore dwzLogStore;
    private final ISequenceService sequenceService;

    public DefaultDwzCorrectErrorDataServiceImpl(IDwzLogStore dwzLogStore, ISequenceService sequenceService) {
        this.dwzLogStore = dwzLogStore;
        this.sequenceService = sequenceService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int correctSequence() {
        try {
            LOGGER.info("==>");
            LOGGER.info("\u5f00\u59cb\u7ea0\u6b63\u5e8f\u5217\u503c\uff0c\u5f53\u524d\u5e8f\u5217\u670d\u52a1\uff1a{}", (Object)this.sequenceService.getClass().getSimpleName());
            long currVal = this.seqCurrValOrNextVal();
            Long maxId = this.dwzLogStore.getMaxId();
            if (maxId == null) {
                maxId = 0L;
            }
            if (currVal < maxId) {
                this.initSeqVal(currVal, maxId);
                int n = 1;
                return n;
            }
            int n = 0;
            return n;
        }
        catch (NotSupportedException e) {
            LOGGER.warn("\u5f53\u524d\u5e8f\u5217\u670d\u52a1\u6216\u77ed\u94fe\u63a5\u8bb0\u5f55\u5b58\u53d6\u670d\u52a1\u4e0d\u652f\u6301\u68c0\u67e5\u5e8f\u5217\u503c\u4e0e\u6700\u5927ID", (Throwable)e);
            int n = -1;
            return n;
        }
        catch (Exception e) {
            LOGGER.error("\u68c0\u67e5\u5e8f\u5217\u7684\u503c\u4e0e\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            LOGGER.info("<==");
        }
    }

    private long seqCurrValOrNextVal() {
        try {
            return this.sequenceService.currVal("SEQ_DWZ_LOG_ID");
        }
        catch (NotSupportedException e) {
            return this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        }
    }

    private void initSeqVal(long currVal, long maxId) {
        try {
            this.sequenceService.setVal("SEQ_DWZ_LOG_ID", maxId);
            LOGGER.warn("\u5f53\u524d\u5e8f\u5217\u503c [{}] \u5c0f\u4e8e\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u503c [{}]\uff0c\u73b0\u5df2\u521d\u59cb\u5316\u5e8f\u5217\u503c\u4e3a\u6700\u5927ID\u503c\u3002\u907f\u514d\u751f\u6210\u5df2\u5b58\u5728\u7684ID\uff0c\u5bfc\u81f4\u521b\u5efa\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25\u3002", (Object)currVal, (Object)maxId);
        }
        catch (NotSupportedException e) {
            LOGGER.warn("\u5f53\u524d\u5e8f\u5217\u503c [{}] \u5c0f\u4e8e\u77ed\u94fe\u63a5\u8bb0\u5f55\u6700\u5927ID\u503c [{}]\uff0c\u4f46\u5f53\u524d\u5e8f\u5217\u670d\u52a1\u4e0d\u652f\u6301 `setVal`\uff0c\u73b0\u6b63\u5728\u8fdb\u884c\u5e8f\u5217\u503c\u7d2f\u52a0\u64cd\u4f5c\uff0c\u76f4\u5230\u5e8f\u5217\u503c\u8fbe\u5230\u6700\u5927ID\u503c\u4e3a\u6b62", (Object)currVal, (Object)maxId);
            while (currVal < maxId) {
                currVal = this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
            }
            LOGGER.warn("\u5f53\u524d\u5e8f\u5217\u503c\u5df2\u8fbe\u5230 [{}]\uff0c\u670d\u52a1\u53ef\u7ee7\u7eed\u8fd0\u884c\u4e86\uff01", (Object)currVal);
        }
    }
}

