/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.middleware.dwz.server.core.store.impls.db;

import icu.easyj.core.sequence.ISequenceService;
import icu.easyj.core.util.StringUtils;
import icu.easyj.core.util.shortcode.ShortCodeUtils;
import icu.easyj.data.store.DbStoreException;
import icu.easyj.db.util.DbClockUtils;
import icu.easyj.middleware.dwz.server.core.domain.entity.DwzLogEntity;
import icu.easyj.middleware.dwz.server.core.store.IDwzLogStore;
import java.util.Date;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DataBaseDwzLogStoreImpl
implements IDwzLogStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataBaseDwzLogStoreImpl.class);
    private static final String DWZ_LOG_TABLE_NAME = "easyj_dwz_log";
    private static final String ALL_FIELDS = "id, short_url_code, long_url, term_of_validity, status, create_time, update_time, version";
    private static final String ALL_PLACEHOLDER = StringUtils.join((char)'?', (char)',', (int)"id, short_url_code, long_url, term_of_validity, status, create_time, update_time, version".split(",").length);
    private static final String INSERT_DWZ_LOG_SQL = "INSERT INTO easyj_dwz_log (id, short_url_code, long_url, term_of_validity, status, create_time, update_time, version) VALUES (" + ALL_PLACEHOLDER + ")";
    private static final String GET_DWZ_LOG_SQL = "SELECT id, short_url_code, long_url, term_of_validity, status, create_time, update_time, version  FROM easyj_dwz_log AS t WHERE t.long_url = ?   FOR UPDATE";
    private static final String UPDATE_DWZ_LOG_SQL = "UPDATE easyj_dwz_log AS t   SET t.term_of_validity = ?,       t.status = 1,       t.update_time = ?,       t.version = t.version + 1 WHERE t.id = ?";
    private static final String GET_LONG_URL_SQL = "SELECT long_url  FROM easyj_dwz_log AS t WHERE t.short_url_code = ?   AND t.status = 1";
    private static final String GET_MAX_ID_SQL = "SELECT MAX(id) FROM easyj_dwz_log";
    private static final String DELETE_OVERTIME_SQL = "DELETE  FROM easyj_dwz_log WHERE term_of_validity < ?   AND status = 1";
    private static final String UPDATE_OVERTIME_SQL = "UPDATE easyj_dwz_log AS t   SET t.status = 2,       t.update_time = ?,       t.version = t.verion + 1 WHERE t.term_of_validity < ?   AND t.status = 1";
    private final DataSource dataSource;
    private final JdbcTemplate jdbcTemplate;
    private final ISequenceService sequenceService;

    public DataBaseDwzLogStoreImpl(JdbcTemplate jdbcTemplate, ISequenceService sequenceService) {
        Assert.notNull((Object)jdbcTemplate, (String)"'jdbcTemplate' must not be null");
        Assert.notNull((Object)jdbcTemplate.getDataSource(), (String)"'jdbcTemplate.getDataSource()' must not be null");
        Assert.notNull((Object)sequenceService, (String)"'sequenceService' must not be null");
        this.jdbcTemplate = jdbcTemplate;
        this.dataSource = jdbcTemplate.getDataSource();
        this.sequenceService = sequenceService;
        LOGGER.info("\u5f53\u524d\u7528\u4e8e\u751f\u6210\u77ed\u94fe\u63a5\u8bb0\u5f55ID\u7684\u5e8f\u5217\u670d\u52a1\u7684\u4e3a\uff1a{}\uff0c\u5bf9\u5e94\u7684\u5e8f\u5217\u540d\uff1a{}\u3002", (Object)sequenceService.getClass().getName(), (Object)"SEQ_DWZ_LOG_ID");
    }

    @Override
    @NonNull
    public DwzLogEntity save(@NonNull String longUrl, @Nullable Date termOfValidity) {
        int rowCount;
        long id = this.sequenceService.nextVal("SEQ_DWZ_LOG_ID");
        String shortUrlCode = ShortCodeUtils.toCode((Long)id);
        Date now = DbClockUtils.now((DataSource)this.dataSource);
        DwzLogEntity dwzLog = new DwzLogEntity();
        dwzLog.setId(id);
        dwzLog.setShortUrlCode(shortUrlCode);
        dwzLog.setLongUrl(longUrl);
        dwzLog.setTermOfValidity(termOfValidity);
        dwzLog.setStatus(1);
        dwzLog.setCreateTime(now);
        dwzLog.setUpdateTime(now);
        dwzLog.setVersion(1);
        try {
            Object[] args = new Object[]{dwzLog.getId(), dwzLog.getShortUrlCode(), dwzLog.getLongUrl(), dwzLog.getTermOfValidity(), dwzLog.getStatus(), dwzLog.getCreateTime(), dwzLog.getUpdateTime(), dwzLog.getVersion()};
            rowCount = this.jdbcTemplate.update(INSERT_DWZ_LOG_SQL, args);
        }
        catch (Exception e) {
            throw new DbStoreException("\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
        if (rowCount != 1) {
            LOGGER.error("\u6570\u636e\u5e93\u672a\u77e5\u5f02\u5e38\uff0c\u77ed\u94fe\u63a5\u8bb0\u5f55\u672a\u521b\u5efa\u6210\u529f\uff01data = {}", (Object)StringUtils.toString((Object)dwzLog));
            throw new DbStoreException("\u6570\u636e\u5e93\u672a\u77e5\u5f02\u5e38\uff0c\u77ed\u94fe\u63a5\u8bb0\u5f55\u672a\u521b\u5efa\u6210\u529f\uff01");
        }
        return dwzLog;
    }

    @Override
    @Nullable
    public DwzLogEntity getByLongUrlForUpdate(@NonNull String longUrl) {
        Assert.notNull((Object)longUrl, (String)"'longUrl' must not be null");
        try {
            return (DwzLogEntity)this.jdbcTemplate.queryForObject(GET_DWZ_LOG_SQL, (RowMapper)new BeanPropertyRowMapper(DwzLogEntity.class), new Object[]{longUrl});
        }
        catch (Exception e) {
            if (e instanceof EmptyResultDataAccessException && ((EmptyResultDataAccessException)e).getActualSize() == 0) {
                return null;
            }
            throw new DbStoreException("\u6839\u636e\u957f\u94fe\u63a5\u83b7\u53d6\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void update(@NonNull DwzLogEntity dwzLog) {
        int result;
        Date now = DbClockUtils.now((DataSource)this.dataSource);
        dwzLog.setUpdateTime(now);
        dwzLog.setVersion(dwzLog.getVersion() + 1);
        try {
            result = this.jdbcTemplate.update(UPDATE_DWZ_LOG_SQL, new Object[]{dwzLog.getTermOfValidity(), dwzLog.getUpdateTime(), dwzLog.getId()});
        }
        catch (Exception e) {
            throw new DbStoreException("\u66f4\u65b0\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
        if (result != 1) {
            throw new DbStoreException("\u66f4\u65b0\u5df2\u6709\u7684\u77ed\u94fe\u63a5\u8bb0\u5f55\u5931\u8d25");
        }
    }

    @Override
    @Nullable
    public String getLongUrlByShortUrlCode(@NonNull String shortUrlCode) {
        try {
            return (String)this.jdbcTemplate.queryForObject(GET_LONG_URL_SQL, String.class, new Object[]{shortUrlCode});
        }
        catch (Exception e) {
            if (e instanceof EmptyResultDataAccessException && ((EmptyResultDataAccessException)e).getActualSize() == 0) {
                return null;
            }
            throw new DbStoreException("\u6839\u636e\u77ed\u94fe\u63a5\u7801\u83b7\u53d6\u957f\u94fe\u63a5\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    @Nullable
    public Long getMaxId() {
        try {
            return (Long)this.jdbcTemplate.queryForObject(GET_MAX_ID_SQL, Long.class);
        }
        catch (Exception e) {
            if (e instanceof EmptyResultDataAccessException && ((EmptyResultDataAccessException)e).getActualSize() == 0) {
                return null;
            }
            throw new DbStoreException("\u83b7\u53d6\u77ed\u94fe\u63a5\u8bb0\u5f55\u7684\u6700\u5927ID\u503c\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public int deleteOvertime() {
        return this.jdbcTemplate.update(DELETE_OVERTIME_SQL, new Object[]{DbClockUtils.now((DataSource)this.dataSource)});
    }

    @Override
    public int updateOvertime() {
        Date now = DbClockUtils.now((DataSource)this.dataSource);
        return this.jdbcTemplate.update(UPDATE_OVERTIME_SQL, new Object[]{now, now});
    }
}

