/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.jwt;

import icu.easyj.jwt.JwtInfo;
import java.util.Date;
import java.util.Map;
import org.springframework.util.Assert;

public interface JwtConstant {
    public static final String[] JWT_SPECIAL_CLAIMS_KEYS = new String[]{"jti", "iat", "exp", "iss", "sub", "aud", "nbf"};
    public static final Date DEFAULT_EXPIRES_AT = null;
    public static final long DEFAULT_LEEWAY = 2L;

    public String create(String var1, Map<String, Object> var2, Date var3, Date var4);

    default public String create(String jwtId, Map<String, Object> claims, Date issuedAt, int expiredTime) {
        if (issuedAt == null) {
            issuedAt = new Date();
        }
        Date expiresAt = null;
        if (expiredTime > 0) {
            expiresAt = new Date(issuedAt.getTime() + (long)(expiredTime * 1000));
        }
        return this.create(jwtId, claims, issuedAt, expiresAt);
    }

    default public String create(JwtInfo jwtInfo) {
        Assert.notNull((Object)jwtInfo, (String)"'jwtInfo' must be not null");
        if (jwtInfo.getIssuedAt() == null) {
            jwtInfo.setIssuedAt(new Date());
        }
        int expiredTime = 0;
        if (jwtInfo.getExpiresAt() != null) {
            expiredTime = (int)((jwtInfo.getExpiresAt().getTime() - jwtInfo.getIssuedAt().getTime()) / 1000L);
        }
        return this.create(jwtInfo.getJwtId(), jwtInfo.getClaims(), jwtInfo.getIssuedAt(), expiredTime);
    }

    default public String create(String jwtId, Map<String, Object> claims, Date issuedAt) {
        return this.create(jwtId, claims, issuedAt, DEFAULT_EXPIRES_AT);
    }

    default public String create(String jwtId, Map<String, Object> claims, int expiredTime) {
        return this.create(jwtId, claims, new Date(), expiredTime);
    }

    default public String create(String jwtId, Map<String, Object> claims) {
        return this.create(jwtId, claims, new Date(), DEFAULT_EXPIRES_AT);
    }

    public JwtInfo verify(String var1, long var2);

    default public JwtInfo verify(String jwtStr) {
        return this.verify(jwtStr, 2000L);
    }

    default public JwtInfo verify(String jwtStr, long leeway, int currentExpiredTime) {
        Date issuedAt;
        JwtInfo jwtInfo = this.verify(jwtStr, leeway);
        if (currentExpiredTime > 0 && (issuedAt = jwtInfo.getIssuedAt()).getTime() + (long)(currentExpiredTime * 1000) <= System.currentTimeMillis()) {
            throw new RuntimeException("JWT\u5df2\u8fc7\u671f");
        }
        return jwtInfo;
    }

    public static void removeSpecialClaims(Map<String, Object> claims) {
        for (String key : JWT_SPECIAL_CLAIMS_KEYS) {
            claims.remove(key);
        }
    }
}

