/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.sdk.ocr.idcardocr;

import icu.easyj.sdk.ocr.CardSide;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrAdvanced;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrResponse;
import icu.easyj.sdk.ocr.idcardocr.IdCardOcrSdkException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public interface IIdCardOcrTemplate {
    @NonNull
    public IdCardOcrResponse idCardOcr(@NonNull String var1, @Nullable CardSide var2, IdCardOcrAdvanced ... var3) throws IdCardOcrSdkException;

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(image, (CardSide)null, advancedArr);
    }

    @NonNull
    default public IdCardOcrResponse idCardOcr(@NonNull String image1, @NonNull String image2, boolean returnIfHasWarn, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        IdCardOcrResponse backResponse;
        IdCardOcrResponse doubleResponse;
        IdCardOcrResponse response2;
        IdCardOcrResponse response = this.idCardOcr(image1, advancedArr);
        if (returnIfHasWarn && !response.getWarns().isEmpty()) {
            return response;
        }
        CardSide cardSide2 = CardSide.FRONT;
        if (response.getCardSide() == CardSide.FRONT) {
            cardSide2 = CardSide.BACK;
        }
        if ((response2 = this.idCardOcr(image2, cardSide2, advancedArr)).getCardSide() == response.getCardSide()) {
            throw new IdCardOcrSdkException("\u4e24\u5f20\u56fe\u7247\u7684\u6b63\u53cd\u9762\u5c5e\u6027\u76f8\u540c", "SAME_CARD_SIDE");
        }
        if (response.getCardSide() == CardSide.FRONT) {
            doubleResponse = response;
            backResponse = response2;
        } else {
            doubleResponse = response2;
            backResponse = response;
        }
        doubleResponse.setCardSide(CardSide.BOTH);
        doubleResponse.setAuthority(backResponse.getAuthority());
        doubleResponse.setValidDateStart(backResponse.getValidDateStart());
        doubleResponse.setValidDateEnd(backResponse.getValidDateEnd());
        doubleResponse.setBackIdCardBase64(backResponse.getIdCardBase64());
        doubleResponse.getWarns().addAll(backResponse.getWarns());
        return doubleResponse;
    }

    default public IdCardOcrResponse idCardOcr(@NonNull String image1, @NonNull String image2, IdCardOcrAdvanced ... advancedArr) throws IdCardOcrSdkException {
        return this.idCardOcr(image1, image2, false, advancedArr);
    }
}

