/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.model;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.annotation.Excel;
import icu.easyj.poi.excel.annotation.ExcelCell;
import icu.easyj.poi.excel.annotation.ExcelCells;
import icu.easyj.poi.excel.model.ExcelMapping;
import java.awt.Color;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.poi.hssf.util.HSSFColor;

public class ExcelCellMapping {
    private Field field;
    private String column;
    private ExcelCell anno;
    private String headName;
    private String headComment;
    private int cellNum;
    private int width = -1;
    private boolean wrapText = false;
    private boolean hidden = false;
    private String color;
    private short colorIndex;
    private String backgroundColor;
    private short backgroundColorIndex;
    private String format;
    private String align;
    private String verAlign;
    private String trueText;
    private String falseText;
    private Map<String, String> convertMap;
    private Map<String, String> convertMap2;

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public ExcelCell getAnno() {
        return this.anno;
    }

    public void setAnno(ExcelCell anno) {
        this.anno = anno;
    }

    public String getHeadName() {
        return this.headName;
    }

    public void setHeadName(String headName) {
        this.headName = headName;
    }

    public String getHeadComment() {
        return this.headComment;
    }

    public void setHeadComment(String headComment) {
        this.headComment = headComment;
    }

    public int getCellNum() {
        return this.cellNum;
    }

    public void setCellNum(int cellNum) {
        this.cellNum = cellNum;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isWrapText() {
        return this.wrapText;
    }

    public void setWrapText(boolean wrapText) {
        this.wrapText = wrapText;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public short getColorIndex() {
        return this.colorIndex;
    }

    public void setColorIndex(short colorIndex) {
        this.colorIndex = colorIndex;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public short getBackgroundColorIndex() {
        return this.backgroundColorIndex;
    }

    public void setBackgroundColorIndex(short backgroundColorIndex) {
        this.backgroundColorIndex = backgroundColorIndex;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public String getVerAlign() {
        return this.verAlign;
    }

    public void setVerAlign(String verAlign) {
        this.verAlign = verAlign;
    }

    public String getTrueText() {
        return this.trueText;
    }

    public void setTrueText(String trueText) {
        this.trueText = trueText;
    }

    public String getFalseText() {
        return this.falseText;
    }

    public void setFalseText(String falseText) {
        this.falseText = falseText;
    }

    public Map<String, String> getConvertMap() {
        return this.convertMap;
    }

    public void setConvertMap(Map<String, String> convertMap) {
        this.convertMap = convertMap;
    }

    public Map<String, String> getConvertMap2() {
        return this.convertMap2;
    }

    public void setConvertMap2(Map<String, String> convertMap2) {
        this.convertMap2 = convertMap2;
    }

    public static List<ExcelCellMapping> getCellMappingList(Class<?> clazz, ExcelMapping mapping) {
        ExcelCellMapping cellMapping;
        Field[] fields;
        ArrayList<ExcelCellMapping> mappingList = new ArrayList<ExcelCellMapping>();
        for (Field f : fields = clazz.getDeclaredFields()) {
            ExcelCells annos;
            ExcelCell anno1 = f.getAnnotation(ExcelCell.class);
            if (anno1 != null) {
                cellMapping = ExcelCellMapping.toMapping(anno1, clazz, f, mapping);
                mappingList.add(cellMapping);
            }
            if ((annos = f.getAnnotation(ExcelCells.class)) == null || annos.value().length <= 0) continue;
            for (ExcelCell anno2 : annos.value()) {
                cellMapping = ExcelCellMapping.toMapping(anno2, clazz, f, mapping);
                mappingList.add(cellMapping);
            }
        }
        if (mapping.getAnno() != null && ArrayUtils.isNotEmpty((Object[])mapping.getAnno().cells())) {
            for (ExcelCell cellAnno : mapping.getAnno().cells()) {
                Field f;
                if (org.springframework.util.StringUtils.isEmpty((Object)cellAnno.column())) {
                    throw new RuntimeException("\u5728@" + Excel.class.getSimpleName() + "\u6ce8\u89e3\u7684cells\u5c5e\u6027\u4e2d\u914d\u7f6e\u7684\u5217\u4fe1\u606f\uff0ccolumn\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
                }
                try {
                    f = ReflectionUtils.getField(clazz, (String)cellAnno.column().split("\\.")[0]);
                }
                catch (NoSuchFieldException e) {
                    throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25\uff1a" + cellAnno.column(), e);
                }
                cellMapping = ExcelCellMapping.toMapping(cellAnno, clazz, f, mapping);
                mappingList.add(cellMapping);
            }
        }
        mappingList.sort(Comparator.comparingInt(ExcelCellMapping::getCellNum));
        return mappingList;
    }

    private static ExcelCellMapping toMapping(ExcelCell anno, Class<?> clazz, Field f, ExcelMapping mapping) {
        int headCellWidth;
        ExcelCellMapping cellMapping = new ExcelCellMapping();
        cellMapping.setField(f);
        if (org.springframework.util.StringUtils.hasText((String)anno.column()) && !anno.column().equals(f.getName())) {
            Field cellField;
            String column = anno.column();
            if (column.startsWith("#") || column.startsWith("$")) {
                column = f.getName() + column.substring(1);
            } else if (column.startsWith(".")) {
                column = f.getName() + column;
            } else if (!column.contains(".")) {
                column = f.getName() + "." + column;
            } else if (!column.startsWith(f.getName())) {
                throw new RuntimeException("\u5728\u7c7b\u201c" + clazz.getName() + "\u201d\u7684\u5c5e\u6027\u201c" + f.getName() + "\u201d\u4e0a\u7684\u6ce8\u89e3@" + ExcelCell.class.getSimpleName() + "(column=\"" + column + "\")\u6709\u8bef");
            }
            cellMapping.setColumn(column);
            try {
                cellField = ReflectionUtils.getField(clazz, (String)column);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("\u83b7\u53d6\u5b57\u6bb5\u5931\u8d25\uff1a" + column, e);
            }
            cellMapping.setField(cellField);
            if (cellMapping.getField() == null) {
                throw new RuntimeException("\u5728\u7c7b\u201c" + clazz.getName() + "\u201d\u4e2d\u672a\u627e\u5230\u5c5e\u6027\uff1a" + column);
            }
        }
        cellMapping.setAnno(anno);
        cellMapping.setHeadName(anno.headName().trim());
        cellMapping.setHeadComment(anno.headComment());
        cellMapping.setCellNum(anno.cellNum());
        cellMapping.setWidth(anno.width());
        cellMapping.setWrapText(anno.wrapText());
        cellMapping.setHidden(anno.hidden());
        cellMapping.setColor(anno.color().toUpperCase());
        cellMapping.setColorIndex(ExcelCellMapping.getColorIndex(cellMapping.getColor()));
        cellMapping.setBackgroundColor(anno.backgroundColor().toUpperCase());
        cellMapping.setBackgroundColorIndex(ExcelCellMapping.getColorIndex(cellMapping.getBackgroundColor()));
        cellMapping.setFormat(anno.format());
        cellMapping.setAlign(anno.align().toLowerCase().trim());
        cellMapping.setVerAlign(anno.verAlign().toLowerCase().trim());
        cellMapping.setTrueText(anno.trueText().trim());
        cellMapping.setFalseText(anno.falseText().trim());
        if (org.springframework.util.StringUtils.hasText((String)anno.convert())) {
            HashMap<String, String> convertMap = new HashMap<String, String>();
            HashMap<String, String> convertMap2 = new HashMap<String, String>();
            String splitRegex = anno.convert().contains("|") ? "\\|" : ",";
            Object[] convertArr = anno.convert().replace("\uff0c", splitRegex).split(splitRegex);
            if (ArrayUtils.isNotEmpty((Object[])convertArr)) {
                for (Object convertPair : convertArr) {
                    String[] convertPairArr = ((String)convertPair).split("=");
                    if (convertPairArr.length != 2) continue;
                    convertMap.put(convertPairArr[0].trim(), convertPairArr[1].trim());
                    convertMap2.put(convertPairArr[1].trim(), convertPairArr[0].trim());
                }
            }
            if (convertMap.keySet().size() == 0) {
                throw new RuntimeException("\u5728\u7c7b\u201c" + clazz.getName() + "\u201d\u4e2d\u7684\u201c" + f.getName() + "\u201d\u5c5e\u6027\u4e0a\u7684@ExcelCellMapping\u6ce8\u89e3\u6240\u914d\u7f6e\u7684convert\u5c5e\u6027\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u3002");
            }
            cellMapping.setConvertMap(convertMap);
            cellMapping.setConvertMap2(convertMap2);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)cellMapping.getFormat())) {
            if (cellMapping.getField().getType().equals(Double.class) || cellMapping.getField().getType().equals(Float.class) || cellMapping.getField().getType().equals(BigDecimal.class)) {
                cellMapping.setFormat("0.00_ ");
            } else if (Number.class.isAssignableFrom(cellMapping.getField().getType())) {
                cellMapping.setFormat("0_ ");
            } else if (cellMapping.getField().getType().equals(Date.class)) {
                cellMapping.setFormat("yyyy-MM-dd HH:mm:ss");
            }
        } else if (cellMapping.getFormat().endsWith("_")) {
            cellMapping.setFormat(cellMapping.getFormat() + " ");
        }
        if (cellMapping.getWidth() <= 0 && cellMapping.getFormat().contains("yyyy")) {
            cellMapping.setWidth((int)((double)cellMapping.getFormat().length() * 6.8 + 8.0 * (1.0 + 8.0 / (double)cellMapping.getFormat().length())));
        }
        if (mapping != null && mapping.isNeedHeadRow() && (headCellWidth = ExcelCellMapping.getCellWidthByText(cellMapping.getHeadName(), 10, true) + (mapping.isNeedFilter() ? 16 : 0)) > 63 && headCellWidth > cellMapping.getWidth()) {
            cellMapping.setWidth(headCellWidth);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)cellMapping.getAlign())) {
            if (cellMapping.getConvertMap() != null) {
                cellMapping.setAlign("center");
            } else if (cellMapping.getField().getType().equals(Date.class) || cellMapping.getField().getType().equals(Boolean.class)) {
                cellMapping.setAlign("center");
            } else if (Number.class.isAssignableFrom(cellMapping.getField().getType())) {
                cellMapping.setAlign("right");
            }
        }
        return cellMapping;
    }

    private static int getCellWidthByText(String text, int size, boolean isBold) {
        int textLength = StringUtils.getStrLength((String)text);
        return (int)((double)textLength * (isBold ? 7.2 : 6.8) * (double)(size / 10)) + 10;
    }

    public static short getColorIndex(String color) {
        if (org.springframework.util.StringUtils.isEmpty((Object)color)) {
            return 0;
        }
        HSSFColor.HSSFColorPredefined hssfColorPredefined = HSSFColor.HSSFColorPredefined.valueOf((String)color);
        if (hssfColorPredefined != null) {
            return hssfColorPredefined.getIndex();
        }
        short colorIndexRet = 0;
        if (color.contains("#")) {
            color = color.replace("#", "");
        }
        if (color.length() == 3) {
            color = "" + color.charAt(0) + color.charAt(0) + color.charAt(1) + color.charAt(1) + color.charAt(2) + color.charAt(2);
        }
        if (color.length() == 6) {
            Color awtColor = Color.getColor(null, Integer.valueOf(color, 16));
            for (Integer colorIndex : HSSFColor.getIndexHash().keySet()) {
                HSSFColor hssfColor = (HSSFColor)HSSFColor.getIndexHash().get(colorIndex);
                short[] triplet = hssfColor.getTriplet();
                if (triplet == null || triplet.length < 3 || awtColor.getRed() != triplet[0] || awtColor.getGreen() != triplet[1] || awtColor.getBlue() != triplet[2]) continue;
                colorIndexRet = Short.valueOf(colorIndex.toString());
                break;
            }
        }
        return colorIndexRet;
    }
}

