/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.poi.excel;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.web.poi.excel.ExcelExport;
import icu.easyj.web.poi.excel.IExcelExporter;
import icu.easyj.web.util.HttpUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483648)
public class ExcelExportAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportAspect.class);
    private static final ThreadLocal<Boolean> DISABLED_LOCAL = new ThreadLocal();
    private final IExcelExporter excelExporter;

    public static void disable() {
        DISABLED_LOCAL.set(true);
    }

    public static void enable() {
        DISABLED_LOCAL.remove();
    }

    public ExcelExportAspect(IExcelExporter excelExporter) {
        this.excelExporter = excelExporter;
    }

    @Pointcut(value="@annotation(icu.easyj.web.poi.excel.ExcelExport)")
    private void pointcutExcelExport() {
    }

    @Around(value="pointcutExcelExport()")
    public Object doQueryAndExportExcel(ProceedingJoinPoint jp) throws Throwable {
        Object result = jp.proceed();
        if (Boolean.TRUE.equals(DISABLED_LOCAL.get())) {
            ExcelExportAspect.enable();
            return result;
        }
        if (HttpUtils.isDoExportRequest()) {
            MethodSignature ms = (MethodSignature)jp.getSignature();
            Method method = ms.getMethod();
            if (result == null || result instanceof List) {
                ExcelExport annotation = method.getAnnotation(ExcelExport.class);
                HttpServletResponse response = HttpUtils.getResponse();
                List dataList = result == null ? Collections.emptyList() : (List)result;
                Class<?> dataType = annotation.dataType();
                String fileName = HttpUtils.buildExportFileName((String)annotation.fileNamePre(), (String)"xlsx");
                this.excelExporter.toExcelAndExport(response, dataList, dataType, fileName);
                return null;
            }
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("\u8fd4\u56de\u6570\u636e\u4e0d\u662f\u5217\u8868\u6570\u636e\uff0c\u4e0d\u652f\u6301Excel\u6587\u4ef6\u5bfc\u51fa\uff0c\u8bf7\u5c06\u6ce8\u89e3`@{}`\u4ece\u65b9\u6cd5`{}`\u4e0a\u79fb\u9664\u3002", (Object)ExcelExport.class.getSimpleName(), (Object)ReflectionUtils.methodToString((Method)method));
            }
        }
        return result;
    }
}

