/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.util;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.poi.excel.functions.ExcelCellValueChangeFuns;
import icu.easyj.poi.excel.model.ExcelCellMapping;
import icu.easyj.poi.excel.model.ExcelMapping;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.util.StringUtils;

public abstract class ExcelCellUtils {
    private static final Map<Class<?>, Map<Class<?>, Function<Object, Object>>> FUN_MAP = new HashMap();

    public static void addChangeFun(Class<?> classFrom, Class<?> classTo, Function<Object, Object> fun) {
        if (fun == null) {
            return;
        }
        Map map = FUN_MAP.computeIfAbsent(classFrom, k -> new HashMap());
        map.put(classTo, fun);
    }

    private static Function<Object, Object> getChangeFun(Class<?> classFrom, Class<?> classTo) {
        Map<Class<?>, Function<Object, Object>> map = FUN_MAP.get(classFrom);
        if (map == null) {
            return null;
        }
        return map.get(classTo);
    }

    public static boolean isEmptyCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        switch (cell.getCellType()) {
            case STRING: {
                String str = cell.getStringCellValue();
                if (!StringUtils.hasText((String)str)) break;
                return false;
            }
            case FORMULA: {
                String str = cell.getCellFormula();
                if (!StringUtils.hasText((String)str)) break;
                return false;
            }
            case NUMERIC: 
            case BOOLEAN: {
                return false;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    public static Object getCellValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue().trim();
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula().trim();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static Object getCellValue(Cell cell, ExcelCellMapping cellMapping) {
        try {
            if (cellMapping.getField().getType().equals(java.util.Date.class)) {
                return cell.getDateCellValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object value = ExcelCellUtils.getCellValue(cell);
        if (value != null) {
            if (cellMapping.getConvertMap2() != null) {
                String convertValue = cellMapping.getConvertMap2().get(value.toString().trim());
                if (StringUtils.hasText((String)convertValue)) {
                    value = convertValue;
                }
            } else if (cellMapping.getField().getType().equals(Boolean.class)) {
                String strValue = value.toString();
                if (strValue.equals(cellMapping.getTrueText()) || "Y".equals(strValue)) {
                    return true;
                }
                if (strValue.equals(cellMapping.getFalseText()) || "N".equals(strValue)) {
                    return false;
                }
            }
        }
        return ExcelCellUtils.changeValueType(value, cellMapping.getField());
    }

    private static Object changeValueType(Object value, Field field) {
        if (value == null || value.toString().isEmpty()) {
            return null;
        }
        if (value.getClass().equals(field.getType())) {
            return value;
        }
        Function<Object, Object> fun = ExcelCellUtils.getChangeFun(value.getClass(), field.getType());
        if (fun == null) {
            throw new RuntimeException("\u7f3a\u5931\u503c\u7c7b\u578b\u8f6c\u6362\u51fd\u6570\uff0c\u65e0\u6cd5\u5c06" + value.getClass().getName() + "\u8f6c\u6362\u4e3a" + field.getType().getName());
        }
        return fun.apply(value);
    }

    public static void setCellValue(Cell cell, Object data, ExcelCellMapping cellMapping) throws NoSuchFieldException {
        String fieldValue2;
        Object fieldValue;
        Object object = fieldValue = StringUtils.isEmpty((Object)cellMapping.getColumn()) ? ReflectionUtils.getFieldValue((Object)data, (Field)cellMapping.getField()) : ReflectionUtils.getFieldValue((Object)data, (String)cellMapping.getColumn());
        if (fieldValue == null) {
            return;
        }
        if (cellMapping.getConvertMap() != null && (fieldValue2 = cellMapping.getConvertMap().get(fieldValue.toString().trim())) != null) {
            cell.setCellValue(fieldValue2);
            return;
        }
        if (fieldValue instanceof java.util.Date) {
            cell.setCellValue((java.util.Date)fieldValue);
        } else if (fieldValue instanceof Double) {
            cell.setCellValue(((Double)fieldValue).doubleValue());
        } else if (fieldValue instanceof Float) {
            cell.setCellValue((double)((Float)fieldValue).floatValue());
        } else if (fieldValue instanceof BigDecimal) {
            cell.setCellValue(((BigDecimal)fieldValue).doubleValue());
        } else if (fieldValue instanceof Number) {
            cell.setCellValue(((Number)fieldValue).doubleValue());
        } else if (fieldValue instanceof Boolean) {
            if (((Boolean)fieldValue).booleanValue()) {
                cell.setCellValue(cellMapping.getTrueText());
            } else {
                cell.setCellValue(cellMapping.getFalseText());
            }
        } else {
            String fieldValueStr = fieldValue.toString();
            if (fieldValueStr.contains("\r\n")) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(fieldValueStr));
            } else {
                cell.setCellValue(fieldValueStr);
            }
        }
    }

    public static void setCellStyle(Sheet sheet, ExcelMapping mapping, boolean isBeforeWriteFile) {
        block42: {
            Row row0;
            block41: {
                int rowSplit;
                if (!isBeforeWriteFile) break block41;
                int cellNum = 0;
                Workbook book = sheet.getWorkbook();
                int colSplit = Math.max(mapping.getFreezeDataCells(), 0);
                int n = rowSplit = mapping.isNeedHeadRow() && mapping.isFreezeHeadRow() ? 1 : 0;
                if (colSplit > 0) {
                    if (mapping.isNeedNumberCell()) {
                        ++colSplit;
                    }
                } else if (mapping.isNeedNumberCell() && mapping.isFreezeNumberCell()) {
                    ++colSplit;
                }
                if (colSplit > 0 || rowSplit > 0) {
                    sheet.createFreezePane(colSplit, rowSplit);
                }
                if (mapping.isNeedNumberCell()) {
                    CellStyle numberCellStyle = book.createCellStyle();
                    numberCellStyle.setDataFormat(book.createDataFormat().getFormat("0_ "));
                    if (mapping.isNeedBorder()) {
                        numberCellStyle.setBorderTop(BorderStyle.THIN);
                        numberCellStyle.setBorderRight(BorderStyle.THIN);
                        numberCellStyle.setBorderBottom(BorderStyle.THIN);
                        numberCellStyle.setBorderLeft(BorderStyle.THIN);
                    }
                    Font font = sheet.getWorkbook().createFont();
                    font.setColor(HSSFColor.HSSFColorPredefined.TEAL.getIndex());
                    numberCellStyle.setFont(font);
                    numberCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    sheet.setDefaultColumnStyle(cellNum, numberCellStyle);
                    ++cellNum;
                }
                for (ExcelCellMapping cellMapping : mapping.getCellMappingList()) {
                    if (cellMapping.getWidth() > 0) {
                        sheet.setColumnWidth(cellNum, (int)((double)cellMapping.getWidth() * 36.1));
                    } else if (mapping.getDefaultWidth() > 0) {
                        sheet.setColumnWidth(cellNum, (int)((double)mapping.getDefaultWidth() * 36.1));
                    }
                    if (cellMapping.isHidden()) {
                        sheet.setColumnHidden(cellNum, true);
                    }
                    CellStyle cellStyle = book.createCellStyle();
                    if (StringUtils.hasText((String)cellMapping.getColor())) {
                        Font font = book.createFont();
                        font.setColor(cellMapping.getColorIndex());
                        cellStyle.setFont(font);
                    }
                    if (StringUtils.hasText((String)cellMapping.getFormat())) {
                        cellStyle.setDataFormat(book.createDataFormat().getFormat(cellMapping.getFormat()));
                    }
                    if (StringUtils.hasText((String)cellMapping.getAlign())) {
                        switch (cellMapping.getAlign()) {
                            case "center": {
                                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                                break;
                            }
                            case "left": {
                                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                                break;
                            }
                            case "right": {
                                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                                break;
                            }
                        }
                    }
                    if (StringUtils.hasText((String)cellMapping.getVerAlign())) {
                        switch (cellMapping.getVerAlign()) {
                            case "middle": 
                            case "center": {
                                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                                break;
                            }
                            case "top": {
                                cellStyle.setVerticalAlignment(VerticalAlignment.TOP);
                                break;
                            }
                            case "bottom": {
                                cellStyle.setVerticalAlignment(VerticalAlignment.BOTTOM);
                                break;
                            }
                            default: {
                                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                            }
                        }
                    }
                    cellStyle.setWrapText(cellMapping.isWrapText());
                    if (StringUtils.hasText((String)cellMapping.getBackgroundColor())) {
                        cellStyle.setFillForegroundColor(cellMapping.getBackgroundColorIndex());
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    if (mapping.isNeedBorder()) {
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                    }
                    sheet.setDefaultColumnStyle(cellNum, cellStyle);
                    ++cellNum;
                }
                break block42;
            }
            if (mapping.isNeedHeadRow() && mapping.isNeedFilter()) {
                CellRangeAddress cra = new CellRangeAddress(0, 0, 0, sheet.getRow(0).getLastCellNum() - 1);
                sheet.setAutoFilter(cra);
            }
            if (!mapping.isWidthAutoSize() || (row0 = sheet.getRow(0)) == null) break block42;
            for (int i = 0; i < row0.getLastCellNum(); ++i) {
                sheet.autoSizeColumn(i, true);
            }
        }
    }

    static {
        ExcelCellUtils.addChangeFun(String.class, String.class, f -> f);
        ExcelCellUtils.addChangeFun(String.class, Character.class, ExcelCellValueChangeFuns::StringToCharacter);
        ExcelCellUtils.addChangeFun(String.class, Character.TYPE, ExcelCellValueChangeFuns::StringToCharacter);
        ExcelCellUtils.addChangeFun(String.class, BigDecimal.class, ExcelCellValueChangeFuns::StringToBigDecimal);
        ExcelCellUtils.addChangeFun(String.class, BigInteger.class, ExcelCellValueChangeFuns::StringToBigInteger);
        ExcelCellUtils.addChangeFun(String.class, Double.class, ExcelCellValueChangeFuns::StringToDouble);
        ExcelCellUtils.addChangeFun(String.class, Double.TYPE, ExcelCellValueChangeFuns::StringToDouble);
        ExcelCellUtils.addChangeFun(String.class, Float.class, ExcelCellValueChangeFuns::StringToFloat);
        ExcelCellUtils.addChangeFun(String.class, Float.TYPE, ExcelCellValueChangeFuns::StringToFloat);
        ExcelCellUtils.addChangeFun(String.class, Long.class, ExcelCellValueChangeFuns::StringToLong);
        ExcelCellUtils.addChangeFun(String.class, Long.TYPE, ExcelCellValueChangeFuns::StringToLong);
        ExcelCellUtils.addChangeFun(String.class, Integer.class, ExcelCellValueChangeFuns::StringToInteger);
        ExcelCellUtils.addChangeFun(String.class, Integer.TYPE, ExcelCellValueChangeFuns::StringToInteger);
        ExcelCellUtils.addChangeFun(String.class, Short.class, ExcelCellValueChangeFuns::StringToShort);
        ExcelCellUtils.addChangeFun(String.class, Short.TYPE, ExcelCellValueChangeFuns::StringToShort);
        ExcelCellUtils.addChangeFun(String.class, Boolean.class, ExcelCellValueChangeFuns::StringToBoolean);
        ExcelCellUtils.addChangeFun(String.class, Boolean.TYPE, ExcelCellValueChangeFuns::StringToBoolean);
        ExcelCellUtils.addChangeFun(String.class, Byte.class, ExcelCellValueChangeFuns::StringToByte);
        ExcelCellUtils.addChangeFun(String.class, Byte.TYPE, ExcelCellValueChangeFuns::StringToByte);
        ExcelCellUtils.addChangeFun(String.class, java.util.Date.class, ExcelCellValueChangeFuns::StringToDate);
        ExcelCellUtils.addChangeFun(String.class, Date.class, ExcelCellValueChangeFuns::StringToSqlDate);
        ExcelCellUtils.addChangeFun(String.class, Time.class, ExcelCellValueChangeFuns::StringToSqlTime);
        ExcelCellUtils.addChangeFun(String.class, Timestamp.class, ExcelCellValueChangeFuns::StringToSqlTimestamp);
        ExcelCellUtils.addChangeFun(Double.class, String.class, ExcelCellValueChangeFuns::doubleToString);
        ExcelCellUtils.addChangeFun(Double.class, BigDecimal.class, ExcelCellValueChangeFuns::doubleToBigDecimal);
        ExcelCellUtils.addChangeFun(Double.class, BigInteger.class, ExcelCellValueChangeFuns::doubleToBigInteger);
        ExcelCellUtils.addChangeFun(Double.class, Double.class, f -> f);
        ExcelCellUtils.addChangeFun(Double.class, Double.TYPE, f -> f);
        ExcelCellUtils.addChangeFun(Double.class, Float.class, ExcelCellValueChangeFuns::doubleToFloat);
        ExcelCellUtils.addChangeFun(Double.class, Float.TYPE, ExcelCellValueChangeFuns::doubleToFloat);
        ExcelCellUtils.addChangeFun(Double.class, Long.class, ExcelCellValueChangeFuns::doubleToLong);
        ExcelCellUtils.addChangeFun(Double.class, Long.TYPE, ExcelCellValueChangeFuns::doubleToLong);
        ExcelCellUtils.addChangeFun(Double.class, Integer.class, ExcelCellValueChangeFuns::doubleToInteger);
        ExcelCellUtils.addChangeFun(Double.class, Integer.TYPE, ExcelCellValueChangeFuns::doubleToInteger);
        ExcelCellUtils.addChangeFun(Double.class, Short.class, ExcelCellValueChangeFuns::doubleToShort);
        ExcelCellUtils.addChangeFun(Double.class, Short.TYPE, ExcelCellValueChangeFuns::doubleToShort);
        ExcelCellUtils.addChangeFun(Double.class, Boolean.class, ExcelCellValueChangeFuns::doubleToBoolean);
        ExcelCellUtils.addChangeFun(Double.class, Boolean.TYPE, ExcelCellValueChangeFuns::doubleToBoolean);
        ExcelCellUtils.addChangeFun(Double.class, Byte.class, ExcelCellValueChangeFuns::doubleToByte);
        ExcelCellUtils.addChangeFun(Double.class, Byte.TYPE, ExcelCellValueChangeFuns::doubleToByte);
        ExcelCellUtils.addChangeFun(Double.class, java.util.Date.class, ExcelCellValueChangeFuns::doubleToDate);
        ExcelCellUtils.addChangeFun(Boolean.class, String.class, ExcelCellValueChangeFuns::booleanToString);
        ExcelCellUtils.addChangeFun(Boolean.class, Double.class, ExcelCellValueChangeFuns::booleanToDouble);
        ExcelCellUtils.addChangeFun(Boolean.class, Double.TYPE, ExcelCellValueChangeFuns::booleanToDouble);
        ExcelCellUtils.addChangeFun(Boolean.class, Float.class, ExcelCellValueChangeFuns::booleanToFloat);
        ExcelCellUtils.addChangeFun(Boolean.class, Float.TYPE, ExcelCellValueChangeFuns::booleanToFloat);
        ExcelCellUtils.addChangeFun(Boolean.class, Long.class, ExcelCellValueChangeFuns::booleanToLong);
        ExcelCellUtils.addChangeFun(Boolean.class, Long.TYPE, ExcelCellValueChangeFuns::booleanToLong);
        ExcelCellUtils.addChangeFun(Boolean.class, Integer.class, ExcelCellValueChangeFuns::booleanToInteger);
        ExcelCellUtils.addChangeFun(Boolean.class, Integer.TYPE, ExcelCellValueChangeFuns::booleanToInteger);
        ExcelCellUtils.addChangeFun(Boolean.class, Short.class, ExcelCellValueChangeFuns::booleanToShort);
        ExcelCellUtils.addChangeFun(Boolean.class, Short.TYPE, ExcelCellValueChangeFuns::booleanToShort);
        ExcelCellUtils.addChangeFun(Boolean.class, Boolean.class, f -> f);
        ExcelCellUtils.addChangeFun(Boolean.class, Boolean.TYPE, f -> f);
        ExcelCellUtils.addChangeFun(Boolean.class, Byte.class, ExcelCellValueChangeFuns::booleanToByte);
        ExcelCellUtils.addChangeFun(Boolean.class, Byte.TYPE, ExcelCellValueChangeFuns::booleanToByte);
    }
}

