/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.poi.excel;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.web.poi.excel.ExcelExport;
import icu.easyj.web.poi.excel.ExcelExportConfig;
import icu.easyj.web.poi.excel.IExcelExporter;
import icu.easyj.web.poi.excel.exception.ExcelExportException;
import icu.easyj.web.util.HttpUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Aspect
@Order(value=-2147483648)
public class ExcelExportAspect {
    private final IExcelExporter excelExporter;
    private final ExcelExportConfig config;

    public ExcelExportAspect(IExcelExporter excelExporter, ExcelExportConfig excelExportConfig) {
        Assert.notNull((Object)excelExporter, (String)"excelExporter must be not null");
        Assert.notNull((Object)excelExportConfig, (String)"excelExportConfig must be not null");
        this.excelExporter = excelExporter;
        this.config = excelExportConfig;
    }

    public ExcelExportAspect(IExcelExporter excelExporter) {
        this(excelExporter, new ExcelExportConfig());
    }

    @Pointcut(value="@annotation(icu.easyj.web.poi.excel.ExcelExport)")
    private void pointcutExcelExport() {
    }

    @Around(value="pointcutExcelExport()")
    public Object doQueryAndExportExcel(ProceedingJoinPoint jp) throws Throwable {
        Object result = jp.proceed();
        if (HttpUtils.isDoExportRequest()) {
            MethodSignature ms = (MethodSignature)jp.getSignature();
            Method method = ms.getMethod();
            ExcelExport annotation = method.getAnnotation(ExcelExport.class);
            if (result != null && !(result instanceof List) && !result.getClass().equals(annotation.dataType())) {
                String listFieldName = StringUtils.findNotEmptyOne((String[])new String[]{annotation.listFieldName(), this.config.getListFieldName()});
                if (org.springframework.util.StringUtils.hasLength((String)listFieldName)) {
                    try {
                        result = ReflectionUtils.getFieldValue(result, (String)listFieldName);
                    }
                    catch (NoSuchFieldException e) {
                        throw new ExcelExportException("\u5728\u8fd4\u56de\u6570\u636e\u4e2d\uff0c\u672a\u627e\u5230\u5c5e\u6027\uff1a" + listFieldName + "\uff0c\u8fd4\u56de\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + result.getClass().getName());
                    }
                } else {
                    throw new ExcelExportException("\u8fd4\u56de\u6570\u636e\u4e0d\u662f\u5217\u8868\u6570\u636e\uff0c\u8bf7\u5728\u6ce8\u89e3\u4e0a\u8bbe\u7f6e`listFieldName`\u6216\u5168\u5c40\u914d\u7f6e`easyj.web.poi.excel.export.list-field-name`\uff0c\u4ece\u6570\u636e\u7684\u5c5e\u6027\u4e2d\u83b7\u53d6\u5217\u8868\u6570\u636e\u3002");
                }
            }
            if (result == null) {
                result = Collections.emptyList();
            } else if (result.getClass().equals(annotation.dataType())) {
                result = Collections.singletonList(result);
            }
            HttpServletResponse response = HttpUtils.getResponse();
            List dataList = result;
            Class<?> dataType = annotation.dataType();
            String fileName = HttpUtils.generateExportFileName((String)annotation.fileNamePre(), (String)"xlsx");
            this.excelExporter.toExcelAndExport(response, dataList, dataType, fileName);
            result = null;
            dataList = null;
            dataType = null;
            fileName = null;
            return null;
        }
        return result;
    }
}

