/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.poi.excel;

import icu.easyj.poi.excel.util.ExcelUtils;
import icu.easyj.web.util.HttpUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelExportUtils {
    public static <T> void toExcelAndExport(HttpServletResponse response, List<T> dataList, Class<T> clazz, String fileName) throws IOException {
        Workbook book = ExcelUtils.toExcel(dataList, clazz);
        ExcelExportUtils.exportExcel(response, book, fileName);
    }

    public static void exportExcel(HttpServletResponse response, Workbook book, String fileName) throws IOException {
        ExcelExportUtils.setExcelExportResponse(response, fileName);
        book.write((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    public static void setExcelExportResponse(HttpServletResponse response, String fileName) throws IOException {
        String fileNameForHeader = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileNameForHeader + "\"");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        HttpUtils.setResponseNotAllowCache((HttpServletResponse)response);
    }

    public static void saveToFile(Workbook book, String targetFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFilePath);){
            book.write((OutputStream)fos);
        }
    }
}

