/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.converter.impls;

import icu.easyj.core.loader.LoadLevel;
import icu.easyj.core.loader.condition.DependsOnClass;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.poi.excel.annotation.Excel;
import icu.easyj.poi.excel.annotation.ExcelCell;
import icu.easyj.poi.excel.converter.IExcelConverter;
import icu.easyj.poi.excel.util.ExcelUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;

@LoadLevel(name="easyj", order=1)
@DependsOnClass(value={Excel.class})
public class EasyjExcelConverter
implements IExcelConverter {
    @Override
    public boolean isMatch(Class<?> clazz) {
        Field[] fields;
        if (clazz.getAnnotation(Excel.class) != null) {
            return true;
        }
        for (Field field : fields = ReflectionUtils.getAllFields(clazz)) {
            if (field.getAnnotation(ExcelCell.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> List<T> toList(InputStream inputStream, Class<T> clazz) throws Exception {
        return ExcelUtils.toList(inputStream, clazz, null);
    }

    @Override
    public <T> Workbook toExcel(List<T> list, Class<T> clazz) throws Exception {
        return ExcelUtils.toExcel(list, clazz);
    }
}

