/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.poi.excel;

import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.converter.ExcelConverterUtils;
import icu.easyj.poi.excel.util.ExcelContext;
import icu.easyj.web.poi.excel.ExcelExport;
import icu.easyj.web.poi.excel.ExcelExportConfig;
import icu.easyj.web.poi.excel.ExcelExportUtils;
import icu.easyj.web.poi.excel.exception.ExcelExportException;
import icu.easyj.web.util.HttpUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Workbook;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.util.Assert;

@Aspect
@Order(value=-2147483348)
public class ExcelExportAspect {
    private final ExcelExportConfig config;

    public ExcelExportAspect(ExcelExportConfig excelExportConfig) {
        Assert.notNull((Object)excelExportConfig, (String)"'excelExportConfig' must not be null");
        this.config = excelExportConfig;
    }

    @Pointcut(value="@annotation(icu.easyj.web.poi.excel.ExcelExport)")
    private void pointcutExcelExport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="pointcutExcelExport()")
    public Object doQueryAndExportExcel(ProceedingJoinPoint jp) throws Throwable {
        try {
            Object result = jp.proceed();
            if (HttpUtils.isDoExportRequest()) {
                MethodSignature ms = (MethodSignature)jp.getSignature();
                Method method = ms.getMethod();
                ExcelExport annotation = method.getAnnotation(ExcelExport.class);
                if (result != null && !(result instanceof List) && !result.getClass().equals(annotation.dataType())) {
                    String listFieldName = StringUtils.findNotEmptyOne((String[])new String[]{annotation.listFieldName(), this.config.getListFieldName()});
                    if (StringUtils.isNotEmpty((CharSequence)listFieldName)) {
                        try {
                            result = ReflectionUtils.getFieldValue(result, (String)listFieldName);
                        }
                        catch (NoSuchFieldException e) {
                            String errorMsg = "\u5728\u8fd4\u56de\u6570\u636e\u7684\u7c7b\u578b\u4e2d\uff0c\u672a\u627e\u5230\u5c5e\u6027\uff1a" + listFieldName + "\uff0c\u8fd4\u56de\u6570\u636e\u7c7b\u578b\u4e3a\uff1a" + result.getClass().getName();
                            throw new ExcelExportException(errorMsg, "NO_SUCH_FIELD");
                        }
                    } else {
                        throw new ExcelExportException("\u8fd4\u56de\u6570\u636e\u4e0d\u662f\u5217\u8868\u6570\u636e\uff0c\u8bf7\u5728\u6ce8\u89e3\u4e0a\u8bbe\u7f6e`listFieldName`\u6216\u5168\u5c40\u914d\u7f6e`easyj.web.poi.excel.export.list-field-name`\uff0c\u4ece\u6570\u636e\u7684\u5c5e\u6027\u4e2d\u83b7\u53d6\u5217\u8868\u6570\u636e\u3002", "NO_CONFIG");
                    }
                }
                if (result == null) {
                    result = Collections.emptyList();
                } else if (result.getClass().equals(annotation.dataType())) {
                    result = Collections.singletonList(result);
                }
                ExcelContext.put("result", result);
                List dataList = result;
                Class<?> dataType = annotation.dataType();
                Workbook workbook = ExcelConverterUtils.toExcel(dataList, dataType);
                HttpServletResponse response = HttpUtils.getResponse();
                String fileName = HttpUtils.generateExportFileName((String)annotation.fileNamePre(), (String)"xlsx");
                ExcelExportUtils.exportExcel(response, workbook, fileName);
                result = null;
                dataList = null;
                dataType = null;
                fileName = null;
                Object var11_14 = null;
                return var11_14;
            }
            List list = result;
            return list;
        }
        finally {
            ExcelContext.remove();
        }
    }
}

