/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.web.poi.excel;

import icu.easyj.web.util.HttpUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class ExcelExportUtils {
    public static void exportExcel(HttpServletResponse response, Workbook book, String fileName) throws IOException {
        ExcelExportUtils.setExcelExportResponse(response, fileName);
        book.write((OutputStream)response.getOutputStream());
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    public static void setExcelExportResponse(HttpServletResponse response, String fileName) throws IOException {
        String fileNameForHeader = new String(fileName.getBytes("gb2312"), "ISO8859-1");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileNameForHeader + "\"");
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        HttpUtils.setResponseNotAllowCache((HttpServletResponse)response);
    }

    public static void saveToFile(Workbook book, String targetFilePath) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetFilePath);){
            book.write((OutputStream)fos);
        }
    }
}

