/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.hook;

import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.annotation.ExcelCustomRowConfig;
import icu.easyj.poi.excel.hook.IListToExcelHook;
import icu.easyj.poi.excel.model.ExcelMapping;
import icu.easyj.poi.excel.util.ExcelCellUtils;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class AbstractListToExcelHook
implements IListToExcelHook {
    @Override
    public void onBeforeCreateHeadRow(Map<Object, Object> context, Sheet sheet, ExcelMapping mapping) {
        this.createCustomFirstRow(context, sheet, mapping);
    }

    @Override
    public void onAfterCreateDataRows(Map<Object, Object> context, Sheet sheet, ExcelMapping mapping) {
        if (mapping.getAnno().showFooterRow()) {
            this.createCustomFooterRow(context, sheet, mapping);
        }
    }

    protected void createCustomFirstRow(Map<Object, Object> context, Sheet sheet, ExcelMapping mapping) {
        String firstRowContent = this.generateCustomFirstRowContent(context);
        if (StringUtils.isBlank((CharSequence)firstRowContent)) {
            return;
        }
        int cellCount = mapping.getCellMappingList().size();
        if (mapping.isNeedNumberCell()) {
            ++cellCount;
        }
        Row row = sheet.createRow(0);
        Cell cell = row.createCell(0);
        cell.setCellValue(firstRowContent);
        CellRangeAddress cra = new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, cellCount - 1);
        sheet.addMergedRegion(cra);
        this.setCustomRowStyle(cell, mapping.getAnno().customFirstRow());
    }

    protected String generateCustomFirstRowContent(Map<Object, Object> context) {
        return null;
    }

    protected void createCustomFooterRow(Map<Object, Object> context, Sheet sheet, ExcelMapping mapping) {
        String footerRowContent = this.generateCustomFooterRowContent(context);
        if (StringUtils.isBlank((CharSequence)footerRowContent)) {
            return;
        }
        int cellCount = mapping.getCellMappingList().size();
        if (mapping.isNeedNumberCell()) {
            ++cellCount;
        }
        Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
        Cell cell = row.createCell(0);
        cell.setCellValue(footerRowContent);
        CellRangeAddress cra = new CellRangeAddress(row.getRowNum(), row.getRowNum(), 0, cellCount - 1);
        sheet.addMergedRegion(cra);
        this.setCustomRowStyle(cell, mapping.getAnno().customFooterRow());
    }

    protected String generateCustomFooterRowContent(Map<Object, Object> context) {
        List dataList = (List)context.get("dataList");
        return "\u603b\u8bb0\u5f55\u6570\uff1a" + dataList.size();
    }

    protected void setCustomRowStyle(Cell cell, ExcelCustomRowConfig configAnno) {
        int fontSize = configAnno.fontSize();
        boolean fontBold = configAnno.fontBold();
        int rowHeight = configAnno.rowHeight();
        HorizontalAlignment align = ExcelCellUtils.convertAlign(configAnno.align(), HorizontalAlignment.CENTER);
        VerticalAlignment verAlign = ExcelCellUtils.convertVerAlign(configAnno.verAlign(), VerticalAlignment.CENTER);
        CellStyle cellStyle = cell.getSheet().getWorkbook().createCellStyle();
        Font font = cell.getSheet().getWorkbook().createFont();
        font.setFontHeight((short)(fontSize * 20));
        font.setColor((short)21);
        if (fontBold) {
            font.setBold(true);
        }
        cellStyle.setFont(font);
        cellStyle.setAlignment(align);
        cellStyle.setVerticalAlignment(verAlign);
        cell.setCellStyle(cellStyle);
        cell.getRow().setHeight((short)(rowHeight * 20));
    }
}

