/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.model;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.MapUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.annotation.Excel;
import icu.easyj.poi.excel.hook.IListToExcelHook;
import icu.easyj.poi.excel.model.ExcelCellMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;

public class ExcelMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class<?> clazz;
    private Excel anno;
    private String sheetName;
    private boolean needBorder = true;
    private int defaultWidth = -1;
    private boolean widthAutoSize = false;
    private boolean needHeadRow = true;
    private boolean freezeHeadRow = true;
    private boolean needNumberCell = true;
    private String numberCellHeadName = "\u5e8f\u53f7";
    private boolean freezeNumberCell = false;
    private int freezeDataCells;
    private boolean needFilter = true;
    private List<ExcelCellMapping> cellMappingList;
    private String[] mergeSameCells;
    private Class<? extends IListToExcelHook>[] toExcelHookClasses;
    private List<IListToExcelHook> toExcelHookList;
    private static final ConcurrentHashMap<Class<?>, ExcelMapping> EXCEL_MAPPING_CACHE = new ConcurrentHashMap();

    public ExcelMapping() {
    }

    public ExcelMapping(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }

    public Excel getAnno() {
        return this.anno;
    }

    public void setAnno(Excel anno) {
        this.anno = anno;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public boolean isNeedBorder() {
        return this.needBorder;
    }

    public void setNeedBorder(boolean needBorder) {
        this.needBorder = needBorder;
    }

    public int getDefaultWidth() {
        return this.defaultWidth;
    }

    public void setDefaultWidth(int defaultWidth) {
        this.defaultWidth = defaultWidth;
    }

    public boolean isWidthAutoSize() {
        return this.widthAutoSize;
    }

    public void setWidthAutoSize(boolean widthAutoSize) {
        this.widthAutoSize = widthAutoSize;
    }

    public boolean isNeedHeadRow() {
        return this.needHeadRow;
    }

    public void setNeedHeadRow(boolean needHeadRow) {
        this.needHeadRow = needHeadRow;
    }

    public boolean isFreezeHeadRow() {
        return this.freezeHeadRow;
    }

    public void setFreezeHeadRow(boolean freezeHeadRow) {
        this.freezeHeadRow = freezeHeadRow;
    }

    public boolean isNeedNumberCell() {
        return this.needNumberCell;
    }

    public void setNeedNumberCell(boolean needNumberCell) {
        this.needNumberCell = needNumberCell;
    }

    public String getNumberCellHeadName() {
        if (StringUtils.isEmpty((CharSequence)this.numberCellHeadName)) {
            this.numberCellHeadName = "\u5e8f\u53f7";
        }
        return this.numberCellHeadName;
    }

    public void setNumberCellHeadName(String numberCellHeadName) {
        this.numberCellHeadName = numberCellHeadName;
    }

    public boolean isFreezeNumberCell() {
        return this.freezeNumberCell;
    }

    public void setFreezeNumberCell(boolean freezeNumberCell) {
        this.freezeNumberCell = freezeNumberCell;
    }

    public int getFreezeDataCells() {
        return this.freezeDataCells;
    }

    public void setFreezeDataCells(int freezeDataCells) {
        this.freezeDataCells = freezeDataCells;
    }

    public boolean isNeedFilter() {
        return this.needFilter;
    }

    public void setNeedFilter(boolean needFilter) {
        this.needFilter = needFilter;
    }

    public List<ExcelCellMapping> getCellMappingList() {
        return this.cellMappingList;
    }

    public void setCellMappingList(List<ExcelCellMapping> cellMappingList) {
        this.cellMappingList = cellMappingList;
    }

    public String[] getMergeSameCells() {
        return this.mergeSameCells;
    }

    public void setMergeSameCells(String[] mergeSameCells) {
        this.mergeSameCells = mergeSameCells;
    }

    public Class<? extends IListToExcelHook>[] getToExcelHookClasses() {
        return this.toExcelHookClasses;
    }

    public ExcelMapping setToExcelHookClasses(Class<? extends IListToExcelHook>[] toExcelHookClasses) {
        this.toExcelHookClasses = toExcelHookClasses;
        return this;
    }

    @Nullable
    public List<IListToExcelHook> getToExcelHookList() {
        if (this.toExcelHookList == null && ArrayUtils.isNotEmpty((Object[])this.toExcelHookClasses)) {
            ArrayList<IListToExcelHook> list = new ArrayList<IListToExcelHook>();
            for (Class<? extends IListToExcelHook> clazz : this.toExcelHookClasses) {
                list.add((IListToExcelHook)ReflectionUtils.getSingleton(clazz));
            }
            this.toExcelHookList = list;
        }
        return this.toExcelHookList;
    }

    public ExcelCellMapping getCellMappingByFieldName(String fieldName) {
        for (ExcelCellMapping cellMapping : this.cellMappingList) {
            if (cellMapping.getColumn() != null && cellMapping.getColumn().equals(fieldName)) {
                return cellMapping;
            }
            if (cellMapping.getField() == null || !cellMapping.getField().getName().equals(fieldName)) continue;
            return cellMapping;
        }
        return null;
    }

    public static ExcelMapping getMapping(Class<?> clazz) {
        return (ExcelMapping)MapUtils.computeIfAbsent(EXCEL_MAPPING_CACHE, clazz, key -> {
            ExcelMapping mapping = new ExcelMapping(clazz);
            Excel anno = clazz.getAnnotation(Excel.class);
            if (anno != null) {
                mapping.setAnno(anno);
                mapping.setSheetName(anno.sheetName());
                mapping.setNeedBorder(anno.needBorder());
                mapping.setDefaultWidth(anno.defaultWidth());
                mapping.setWidthAutoSize(anno.widthAutoSize());
                mapping.setNeedHeadRow(anno.needHeadRow());
                mapping.setFreezeHeadRow(anno.needHeadRow() && anno.freezeHeadRow());
                mapping.setNeedNumberCell(anno.needNumberCell());
                mapping.setNumberCellHeadName(anno.numberCellHeadName());
                mapping.setFreezeNumberCell(anno.needNumberCell() && anno.freezeNumberCell());
                mapping.setFreezeDataCells(anno.freezeDataCells());
                mapping.setNeedFilter(anno.needFilter());
                mapping.setToExcelHookClasses(anno.toExcelHookClasses());
                mapping.setMergeSameCells(anno.mergeSameCells());
            }
            List<ExcelCellMapping> cellMappingList = ExcelCellMapping.getCellMappingList(clazz, mapping);
            mapping.setCellMappingList(cellMappingList);
            return mapping;
        });
    }
}

