/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.util;

import icu.easyj.core.convert.ConvertUtils;
import icu.easyj.core.util.NumberUtils;
import icu.easyj.core.util.PatternUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.model.ExcelCellMapping;
import icu.easyj.poi.excel.model.ExcelMapping;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.lang.Nullable;

public abstract class ExcelCellUtils {
    public static boolean isEmptyCell(Cell cell) {
        if (cell == null) {
            return true;
        }
        CellType cellType = ExcelCellUtils.getCellType(cell);
        switch (cellType) {
            case STRING: {
                String str = cell.getStringCellValue();
                if (!StringUtils.isNotBlank((CharSequence)str)) break;
                return false;
            }
            case FORMULA: {
                String str = cell.getCellFormula();
                if (!StringUtils.isNotBlank((CharSequence)str)) break;
                return false;
            }
            case NUMERIC: 
            case BOOLEAN: {
                return false;
            }
            default: {
                return true;
            }
        }
        return true;
    }

    public static Object getCellValue(Cell cell) {
        CellType cellType = ExcelCellUtils.getCellType(cell);
        switch (cellType) {
            case STRING: {
                String str = cell.getStringCellValue().trim();
                if (StringUtils.isNotEmpty((CharSequence)str) && PatternUtils.validate((String)"[`']-?\\d+(\\.\\d*([eE]-?\\d+)?)?", (CharSequence)str)) {
                    str = str.substring(1);
                }
                return str;
            }
            case NUMERIC: {
                return cell.getNumericCellValue();
            }
            case FORMULA: {
                return cell.getCellFormula().trim();
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
        }
        return null;
    }

    public static Object getCellValue(Cell cell, ExcelCellMapping cellMapping) {
        try {
            if (cellMapping.getField().getType().equals(Date.class)) {
                return cell.getDateCellValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object value = ExcelCellUtils.getCellValue(cell);
        if (value != null) {
            if (cellMapping.getConvertMap2() != null) {
                String convertValue = cellMapping.getConvertMap2().get(value.toString().trim());
                if (StringUtils.isNotBlank((CharSequence)convertValue)) {
                    value = convertValue;
                }
            } else if (cellMapping.getField().getType().equals(Boolean.class)) {
                String strValue = value.toString();
                if (strValue.equals(cellMapping.getTrueText()) || "Y".equals(strValue)) {
                    return true;
                }
                if (strValue.equals(cellMapping.getFalseText()) || "N".equals(strValue)) {
                    return false;
                }
            }
        }
        return ExcelCellUtils.convert(value, cellMapping.getField().getType());
    }

    public static <T> T convert(Object value, Class<T> targetClass) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double && String.class.equals(targetClass)) {
            Double d = (Double)value;
            return (T)NumberUtils.doubleToString((Double)d);
        }
        return (T)ConvertUtils.convert((Object)value, targetClass);
    }

    public static <T> T getCellValue(Cell cell, Class<T> targetClass) {
        if (targetClass.equals(Date.class)) {
            try {
                return (T)cell.getDateCellValue();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        Object value = ExcelCellUtils.getCellValue(cell);
        return (T)ConvertUtils.convert((Object)value, targetClass);
    }

    public static void setCellValue(Cell cell, Object data, ExcelCellMapping cellMapping) throws NoSuchFieldException {
        String fieldValue2;
        Object fieldValue;
        Object object = fieldValue = StringUtils.isEmpty((CharSequence)cellMapping.getColumn()) ? ReflectionUtils.getFieldValue((Object)data, (Field)cellMapping.getField()) : ReflectionUtils.getFieldValue((Object)data, (String)cellMapping.getColumn());
        if (fieldValue == null) {
            return;
        }
        if (cellMapping.getConvertMap() != null && (fieldValue2 = cellMapping.getConvertMap().get(fieldValue.toString().trim())) != null) {
            cell.setCellValue(fieldValue2);
            return;
        }
        if (fieldValue instanceof Date) {
            cell.setCellValue((Date)fieldValue);
        } else if (fieldValue instanceof Number) {
            ExcelCellUtils.setCellNumberValue(cell, (Number)fieldValue);
        } else if (fieldValue instanceof Boolean) {
            if (((Boolean)fieldValue).booleanValue()) {
                cell.setCellValue(cellMapping.getTrueText());
            } else {
                cell.setCellValue(cellMapping.getFalseText());
            }
        } else {
            String fieldValueStr = fieldValue.toString();
            if (fieldValueStr.contains("\r\n")) {
                cell.setCellValue((RichTextString)new HSSFRichTextString(fieldValueStr));
            } else {
                cell.setCellValue(fieldValueStr);
            }
        }
    }

    private static void setCellNumberValue(Cell cell, Number numberValue) {
        double doubleValue = numberValue.doubleValue();
        if (doubleValue > 2.147483647E9 || doubleValue < -2.147483648E9) {
            cell.setCellValue("'" + numberValue);
        } else {
            cell.setCellValue(doubleValue);
        }
    }

    public static void setCellStyle(Sheet sheet, ExcelMapping mapping, int headRowNum, boolean isBeforeWriteFile) {
        block20: {
            Row row0;
            block19: {
                int rowSplit;
                if (!isBeforeWriteFile) break block19;
                int cellNum = 0;
                Workbook book = sheet.getWorkbook();
                int colSplit = Math.max(mapping.getFreezeDataCells(), 0);
                int n = rowSplit = mapping.isNeedHeadRow() && mapping.isFreezeHeadRow() ? 1 : 0;
                if (colSplit > 0) {
                    if (mapping.isNeedNumberCell()) {
                        ++colSplit;
                    }
                } else if (mapping.isNeedNumberCell() && mapping.isFreezeNumberCell()) {
                    ++colSplit;
                }
                if (colSplit > 0 || rowSplit > 0) {
                    sheet.createFreezePane(colSplit, rowSplit);
                }
                if (mapping.isNeedNumberCell()) {
                    CellStyle numberCellStyle = book.createCellStyle();
                    numberCellStyle.setDataFormat(book.createDataFormat().getFormat("0_ "));
                    if (mapping.isNeedBorder()) {
                        numberCellStyle.setBorderTop(BorderStyle.THIN);
                        numberCellStyle.setBorderRight(BorderStyle.THIN);
                        numberCellStyle.setBorderBottom(BorderStyle.THIN);
                        numberCellStyle.setBorderLeft(BorderStyle.THIN);
                    }
                    Font font = sheet.getWorkbook().createFont();
                    font.setColor((short)21);
                    numberCellStyle.setFont(font);
                    numberCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                    sheet.setDefaultColumnStyle(cellNum, numberCellStyle);
                    ++cellNum;
                }
                for (ExcelCellMapping cellMapping : mapping.getCellMappingList()) {
                    HorizontalAlignment align;
                    if (cellMapping.getWidth() > 0) {
                        sheet.setColumnWidth(cellNum, (int)((double)cellMapping.getWidth() * 36.1));
                    } else if (mapping.getDefaultWidth() > 0) {
                        sheet.setColumnWidth(cellNum, (int)((double)mapping.getDefaultWidth() * 36.1));
                    }
                    if (cellMapping.isHidden()) {
                        sheet.setColumnHidden(cellNum, true);
                    }
                    CellStyle cellStyle = book.createCellStyle();
                    if (StringUtils.isNotBlank((CharSequence)cellMapping.getColor())) {
                        Font font = book.createFont();
                        font.setColor(cellMapping.getColorIndex());
                        cellStyle.setFont(font);
                    }
                    if (StringUtils.isNotBlank((CharSequence)cellMapping.getFormat())) {
                        cellStyle.setDataFormat(book.createDataFormat().getFormat(cellMapping.getFormat()));
                    }
                    if ((align = ExcelCellUtils.convertAlign(cellMapping.getAlign(), null)) != null) {
                        cellStyle.setAlignment(align);
                    }
                    VerticalAlignment verAlign = ExcelCellUtils.convertVerAlign(cellMapping.getVerAlign(), VerticalAlignment.CENTER);
                    cellStyle.setVerticalAlignment(verAlign);
                    cellStyle.setWrapText(cellMapping.isWrapText());
                    if (StringUtils.isNotBlank((CharSequence)cellMapping.getBackgroundColor())) {
                        cellStyle.setFillForegroundColor(cellMapping.getBackgroundColorIndex());
                        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                    }
                    if (mapping.isNeedBorder()) {
                        cellStyle.setBorderTop(BorderStyle.THIN);
                        cellStyle.setBorderRight(BorderStyle.THIN);
                        cellStyle.setBorderBottom(BorderStyle.THIN);
                        cellStyle.setBorderLeft(BorderStyle.THIN);
                    }
                    sheet.setDefaultColumnStyle(cellNum, cellStyle);
                    ++cellNum;
                }
                break block20;
            }
            if (mapping.isNeedHeadRow() && mapping.isNeedFilter()) {
                CellRangeAddress cra = new CellRangeAddress(headRowNum, headRowNum, 0, sheet.getRow(headRowNum).getLastCellNum() - 1);
                sheet.setAutoFilter(cra);
            }
            if (!mapping.isWidthAutoSize() || (row0 = sheet.getRow(0)) == null) break block20;
            for (int i = 0; i < row0.getLastCellNum(); ++i) {
                sheet.autoSizeColumn(i, true);
            }
        }
    }

    public static HorizontalAlignment convertAlign(String align, @Nullable HorizontalAlignment defaultAlign) {
        if (align == null) {
            return defaultAlign;
        }
        switch (align.toLowerCase()) {
            case "center": {
                return HorizontalAlignment.CENTER;
            }
            case "left": {
                return HorizontalAlignment.LEFT;
            }
            case "right": {
                return HorizontalAlignment.RIGHT;
            }
        }
        return defaultAlign;
    }

    public static VerticalAlignment convertVerAlign(String verAlign, @Nullable VerticalAlignment defaultVerAlign) {
        if (verAlign == null) {
            return defaultVerAlign;
        }
        switch (verAlign.toLowerCase()) {
            case "middle": 
            case "center": {
                return VerticalAlignment.CENTER;
            }
            case "top": {
                return VerticalAlignment.TOP;
            }
            case "bottom": {
                return VerticalAlignment.BOTTOM;
            }
        }
        return defaultVerAlign;
    }

    public static CellType getCellType(Cell cell) {
        Object cellTypeValue;
        try {
            cellTypeValue = ReflectionUtils.invokeMethod((Object)cell, (String)"getCellType");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No such method: " + Cell.class.getName() + ".getCellType()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invoke method failed: " + Cell.class.getName() + ".getCellType()", e);
        }
        CellType cellType = cellTypeValue instanceof CellType ? (CellType)cellTypeValue : CellType.forInt((int)Integer.parseInt(cellTypeValue.toString()));
        return cellType;
    }

    public static HorizontalAlignment getCellStyleAlignment(CellStyle cellStyle) {
        Object alignmentValue;
        try {
            alignmentValue = ReflectionUtils.invokeMethod((Object)cellStyle, (String)"getAlignment");
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("No such method: " + CellStyle.class.getName() + ".getAlignment()", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invoke method failed: " + CellStyle.class.getName() + ".getAlignment()", e);
        }
        HorizontalAlignment alignment = alignmentValue instanceof HorizontalAlignment ? (HorizontalAlignment)alignmentValue : HorizontalAlignment.forInt((int)Integer.parseInt(alignmentValue.toString()));
        return alignment;
    }
}

