/*
 * Decompiled with CFR 0.152.
 */
package icu.easyj.poi.excel.util;

import icu.easyj.core.util.ArrayUtils;
import icu.easyj.core.util.ReflectionUtils;
import icu.easyj.core.util.StringUtils;
import icu.easyj.poi.excel.model.ExcelCellMapping;
import icu.easyj.poi.excel.model.ExcelMapping;
import icu.easyj.poi.excel.util.ExcelCellUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public abstract class ExcelRowUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExcelRowUtils.class);

    @NonNull
    public static <T> T rowToObject(Row row, boolean hasNumberCell, Row headRow, Class<T> clazz, ExcelMapping mapping) throws Exception {
        try {
            T t = clazz.newInstance();
            short cellStart = row.getFirstCellNum();
            short cellEnd = row.getLastCellNum();
            for (ExcelCellMapping cellMapping : mapping.getCellMappingList()) {
                Object value;
                Cell cell;
                int cellNum = cellMapping.getCellNum();
                if (hasNumberCell) {
                    ++cellNum;
                }
                if (headRow != null && (cellNum = ExcelRowUtils.getCellNumByHead(headRow, cellNum, cellMapping)) == -1 || cellNum < cellStart || cellNum >= cellEnd || ExcelCellUtils.isEmptyCell(cell = row.getCell(cellNum)) || (value = ExcelCellUtils.getCellValue(cell, cellMapping)) == null || value.toString().trim().isEmpty()) continue;
                if (StringUtils.isEmpty((CharSequence)cellMapping.getColumn())) {
                    ReflectionUtils.setFieldValue(t, (Field)cellMapping.getField(), (Object)value);
                    continue;
                }
                ReflectionUtils.setFieldValue(t, (String)cellMapping.getColumn(), (Object)value);
            }
            return t;
        }
        catch (Exception e) {
            LOGGER.error("excel\u7684\u884c\u8f6c\u6362\u4e3a\u5bf9\u8c61\u65f6\u5f02\u5e38\uff1a--------\r\n{}\r\n-----------------------------------", (Object)e.getMessage());
            throw e;
        }
    }

    public static int getCellNumByHead(Row headRow, int cellNum, ExcelCellMapping cellMapping) {
        Object value;
        Cell cell = headRow.getCell(cellNum);
        if (cell != null && (value = ExcelCellUtils.getCellValue(cell)) != null && value.toString().trim().equals(cellMapping.getHeadName())) {
            return cellNum;
        }
        for (int i = 0; i < headRow.getLastCellNum(); ++i) {
            cell = headRow.getCell(i);
            if (cell == null || (value = ExcelCellUtils.getCellValue(cell)) == null || !value.toString().trim().equals(cellMapping.getHeadName())) continue;
            return i;
        }
        return -1;
    }

    public static boolean isHeadRow(Row row, ExcelMapping mapping) {
        short cellStart = row.getFirstCellNum();
        short cellEnd = row.getLastCellNum();
        for (ExcelCellMapping em : mapping.getCellMappingList()) {
            Object value;
            Cell cell;
            if (em.getCellNum() < cellStart || em.getCellNum() >= cellEnd || em.getHeadName() == null || em.getHeadName().isEmpty() || (cell = row.getCell(em.getCellNum())) == null || (value = ExcelCellUtils.getCellValue(cell)) == null || value.toString().isEmpty() || !"\u5e8f\u53f7".equals(value.toString()) && !value.toString().equals(em.getHeadName()) && !value.toString().equals(mapping.getNumberCellHeadName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyRow(Row row) {
        if (row == null) {
            return true;
        }
        int cellStart = row.getFirstCellNum();
        short cellEnd = row.getLastCellNum();
        for (int i = cellStart; i <= cellEnd; ++i) {
            try {
                Cell cell = row.getCell(i);
                if (ExcelCellUtils.isEmptyCell(cell)) continue;
                return false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static void createHeadRow(Sheet sheet, ExcelMapping mapping) {
        Cell cell;
        if (!mapping.isNeedHeadRow()) {
            return;
        }
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        Font font = sheet.getWorkbook().createFont();
        font.setColor((short)21);
        font.setBold(true);
        cellStyle.setFont(font);
        if (mapping.isNeedFilter()) {
            cellStyle.setAlignment(HorizontalAlignment.LEFT);
        } else {
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
        }
        Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
        int cellNum = 0;
        if (mapping.isNeedNumberCell()) {
            cell = row.createCell(cellNum++);
            cell.setCellValue(mapping.getNumberCellHeadName());
            cell.setCellStyle(cellStyle);
        }
        CreationHelper factory = sheet.getWorkbook().getCreationHelper();
        Drawing drawing = sheet.createDrawingPatriarch();
        ClientAnchor anchor = factory.createClientAnchor();
        for (ExcelCellMapping cm : mapping.getCellMappingList()) {
            cell = row.createCell(cellNum++);
            cell.setCellValue(cm.getHeadName());
            CellStyle cs = cell.getCellStyle();
            if (cs != null) {
                cs = sheet.getWorkbook().createCellStyle();
                cs.cloneStyleFrom(cell.getCellStyle());
                cs.setFont(font);
                cs.setAlignment(ExcelCellUtils.getCellStyleAlignment(cellStyle));
            } else {
                cs = cellStyle;
            }
            cell.setCellStyle(cs);
            if (!StringUtils.isNotBlank((CharSequence)cm.getHeadComment())) continue;
            Comment comment1 = drawing.createCellComment(anchor);
            RichTextString str1 = factory.createRichTextString(cm.getHeadComment());
            comment1.setString(str1);
            cell.setCellComment(comment1);
        }
    }

    public static void createDataRows(Sheet sheet, List<?> dataList, ExcelMapping mapping) {
        int rowNum = sheet.getPhysicalNumberOfRows();
        int number = 1;
        for (Object data : dataList) {
            Cell cell;
            int cellNum = 0;
            Row row = sheet.createRow(rowNum++);
            if (mapping.isNeedNumberCell()) {
                cell = row.createCell(cellNum++);
                cell.setCellValue((double)number++);
            }
            for (ExcelCellMapping cellMapping : mapping.getCellMappingList()) {
                if (cellMapping.getField() == null) continue;
                cell = row.createCell(cellNum++);
                try {
                    ExcelCellUtils.setCellValue(cell, data, cellMapping);
                }
                catch (Exception e) {
                    LOGGER.error("\u8bbe\u7f6e\u5217\u201c{}\u201d\u7684\u4fe1\u606f\u5931\u8d25\uff1a{}", new Object[]{cellMapping.getHeadName(), e.getMessage(), e});
                }
            }
        }
    }

    public static void mergeSameCells(Sheet sheet, ExcelMapping mapping) {
        int startRow;
        if (ArrayUtils.isEmpty((Object[])mapping.getMergeSameCells())) {
            return;
        }
        String[] mergeFieldNames = mapping.getMergeSameCells();
        int[] mergeCellNums = ExcelRowUtils.getMergeCellNums(mapping, mergeFieldNames);
        Arrays.sort(mergeCellNums);
        if (mapping.isNeedNumberCell()) {
            int i = 0;
            while (i < mergeCellNums.length) {
                int n = i++;
                mergeCellNums[n] = mergeCellNums[n] + 1;
            }
        }
        int mergeStartRow = -1;
        int mergeEndRow = -1;
        for (int i = startRow = mapping.isNeedHeadRow() ? 3 : 2; i < sheet.getPhysicalNumberOfRows(); ++i) {
            if (ExcelRowUtils.isSameCells(sheet.getRow(i - 1), sheet.getRow(i), mergeCellNums)) {
                if (mergeStartRow == -1) {
                    mergeStartRow = i - 1;
                    mergeEndRow = i;
                    continue;
                }
                ++mergeEndRow;
                continue;
            }
            if (mergeStartRow < 0) continue;
            int[] nArray = mergeCellNums;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int mergeCellNum = nArray[j];
                sheet.addMergedRegion(new CellRangeAddress(mergeStartRow, mergeEndRow, mergeCellNum, mergeCellNum));
            }
            mergeStartRow = -1;
            mergeEndRow = -1;
        }
        if (mergeStartRow >= 0) {
            for (int mergeCellNum : mergeCellNums) {
                sheet.addMergedRegion(new CellRangeAddress(mergeStartRow, mergeEndRow, mergeCellNum, mergeCellNum));
            }
        }
    }

    private static int[] getMergeCellNums(ExcelMapping mapping, String[] mergeFieldNames) {
        int[] mergeCellNums = new int[mergeFieldNames.length];
        for (int i = 0; i < mergeFieldNames.length; ++i) {
            String mergeFieldName = mergeFieldNames[i];
            ExcelCellMapping cellMapping = mapping.getCellMappingByFieldName(mergeFieldName);
            if (cellMapping == null) {
                throw new IllegalArgumentException("\u627e\u4e0d\u5230\u9700\u8981\u5408\u5e76\u5355\u5143\u683c\u7684\u5217\u540d\uff1a" + mergeFieldName);
            }
            mergeCellNums[i] = cellMapping.getCellNum();
        }
        return mergeCellNums;
    }

    private static boolean isSameCells(Row row1, Row row2, int[] cellNums) {
        for (int cellNum : cellNums) {
            Object value2;
            Cell row1Cell = row1.getCell(cellNum);
            Cell row2Cell = row2.getCell(cellNum);
            Object value1 = ExcelCellUtils.getCellValue(row1Cell);
            if (Objects.equals(value1, value2 = ExcelCellUtils.getCellValue(row2Cell))) continue;
            return false;
        }
        return true;
    }
}

